package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.dto.*;
import com.zbkj.common.exception.CrmebWalletException;
import com.zbkj.common.model.huifu.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <b>  </b>
 * @author ZXF
 * @create 2023/08/01 0001 13:19
 * @version
 * @注意事项 </b>
 */
public interface CommonWalletService extends IService<HuifuWallet> {

    /**
     * 银行信息查询
     * @param bankConfig
     * @return
     */
    List<BankConfig> findBank(BankConfig bankConfig) throws CrmebWalletException;

    /**
     * <b> 获取企业钱包账户交易明细（请求转存数据，当天只能查到昨天的数据） </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    PageInfo<HuifuWalletAccountDetail> thisHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto) throws CrmebWalletException;

    /**
     * 企业钱包充值回调
     *
     * @param dto
     * @author llc
     * @date 2019-06-28
     */
    String huifuWalletRechargeCallback(HuifuRequestDataDto dto);

    /**
     * 企业钱包提现回调
     *
     * @param messageBody
     * @author llc
     * @date 2019-06-28
     */
    String huifuWalletExtractCallback(String messageBody);

    /**
     * 获取企业充值交易状态
     *
     * @param huifuWalletTrade
     * @author llc
     * @date 2019-06-28
     */
    HuifuWalletTrade getWalletTradeInfo(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException;

    /**
     * <b> 交易结算对账文件重新生成 </b>
     * @param tradeDate 指定日期，例：20230816
     * @author ZXF
     * @create 2023/08/12 0012 13:33
     * @version
     * @注意事项 </b>
     */
    String reconciliationReplay(String tradeDate);

    /**
     * 企业钱包账户对账数据生成
     *
     * @author llc
     * @date 2019-09-16
     */
    String createHuifuWalletReconciliation();

    /**
     * 获取企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-19
     */
    Map<String, Object> getHuifuWalletReconciliation(HuifuWalletTradeDto dto) throws CrmebWalletException;

    /**
     * 导出企业钱包账户对账数据
     *
     * @author llc
     * @date 2019-09-20
     */
    String exportHuifuWalletReconciliation(HuifuWalletTradeDto dto, HttpServletResponse response) throws CrmebWalletException;
    /**
     * <b> 根据业务编码或业务交易流水号查询交易信息 </b>
     * @author ZXF
     * @create 2023/03/23 0023 10:20
     * @version
     * @注意事项 </b>
     */
    List<HuifuWalletTrade> getHuifuWalletTradeBySeqAndCode(HuifuWalletTrade huifuWalletTrade) throws CrmebWalletException;
    /**
     * <b> 余额支付交易分账明细查询 定时任务 TODO 实时依据余额支付接口生成收支明细 </b>
     * @author ZXF
     * @create 2023/11/13 0013 23:31
     * @version
     * @注意事项 </b>
     */
//    void payTradeDetailTaskSch();
    /**
     * 导出企业钱包账户交易明细数据
     *
     * @author llc
     * @date 2019-09-20
     */
    String exportHuifuWalletAccountTradeDetail(HuifuWalletAccountDetailDto dto, HttpServletResponse response) throws CrmebWalletException;
    /**
     * <b> 获取企业钱包账户提现记录 </b>
     * @author ZXF
     * @create 2023/04/23 0023 10:37
     * @version
     * @注意事项 </b>
     */
    PageInfo<HuifuWalletTranslog> thisHuifuWalletTranslog(HuifuWalletTranslogDto dto) throws CrmebWalletException;

    /**
     * <b> 修改冻结金额 </b>
     * @author ZXF
     * @create 2025/07/23 0023 17:07
     * @version
     * @注意事项 </b>
     */
    boolean modifyBalance(String uniId, BigDecimal amount,String payChannel);
}
