package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxUserBank;
import com.zbkj.common.request.BcxUserAddBankCardRequest;
import com.zbkj.common.request.BcxUserEditBankCardRequest;
import com.zbkj.common.request.BcxUserOperateBankCardRequest;
import com.zbkj.common.request.PageParamRequest;

import java.util.List;

/**
 * description：用户绑定银行卡表 服务接口
 * author：linchunpeng
 * date：2023/11/1
 */
public interface BcxUserBankService extends IService<BcxUserBank> {

    /**
     * description：获取银行卡列表
     * author：linchunpeng
     * date：2023/11/1
     */
    PageInfo<BcxUserBank> getPage(PageParamRequest pageParamRequest);

    /**
     * description：绑定银行卡
     * author：linchunpeng
     * date：2023/11/1
     */
    Boolean bindBankCard(BcxUserAddBankCardRequest request);

    /**
     * description：编辑银行卡
     * author：linchunpeng
     * date：2023/11/1
     */
    Boolean editBankCard(BcxUserEditBankCardRequest request);

    /**
     * description：设置默认银行卡
     * author：linchunpeng
     * date：2023/11/1
     */
    Boolean setBankCardDefault(BcxUserOperateBankCardRequest request);

    /**
     * description：解绑银行卡
     * author：linchunpeng
     * date：2023/11/1
     */
    Boolean unbindBankCard(BcxUserOperateBankCardRequest request);
}