package com.zbkj.service.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zbkj.common.model.bcx.BcxDepartment;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;

import java.util.List;

/**
 * description: 部门表 服务接口
 * author : linchunpeng
 * date : 2023/8/3
 */
public interface BcxDepartmentService extends IService<BcxDepartment> {

    /**
     * description：获取部门tree列表
     * author：linchunpeng
     * date：2023/8/4
     */
    List<BcxDepartmentResponse> findAllTree();

    /**
     * description：获取部门tree列表（含部门成员）
     * author：linchunpeng
     * date：2023/8/4
     */
    List<BcxDepartmentResponse> findAllTreeWithMember(List<BcxDepartmentMemberResponse> memberResponseList);

    /**
     * description：根据v5id查询部门
     * author：linchunpeng
     * date：2023/8/21
     */
    BcxDepartment findByBcxId(String bcxId);
}