package com.zbkj.service.huifu.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeCheckFilequeryRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.service.huifu.core.Identify;

import java.util.HashMap;
import java.util.Map;

/**
 * 交易结算对账单查询 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeCheckFilequeryRequest.class)
public class V2TradeCheckFilequery {

    public static V2TradeCheckFilequeryRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeCheckFilequeryRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeCheckFilequeryRequest.class);
//        V2TradeCheckFilequeryRequest request = new V2TradeCheckFilequeryRequest();
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 汇付客户Id
//        request.setHuifuId("6666000108854952");
        // 文件生成日期
//        request.setFileDate("20220822");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 文件类型
        extendInfoMap.put("file_type_query", map.get("fileTypeQuery"));
        return extendInfoMap;
    }

}
