/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.video.PayComponentOrder;
import com.zbkj.common.model.wechat.video.PayComponentOrderProduct;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.vo.wxvedioshop.ShopAftersaleAddVo;
import com.zbkj.common.vo.wxvedioshop.ShopAftersaleUpdateVo;
import com.zbkj.common.vo.wxvedioshop.ShopOrderAddResultVo;
import com.zbkj.common.vo.wxvedioshop.aftersale.AftersaleProductInfoVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderAddressInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPayInfoAddVo;
import com.zbkj.common.vo.wxvedioshop.order.ShopOrderPriceInfoVo;
import com.zbkj.service.dao.PayComponentOrderDao;
import com.zbkj.service.service.PayComponentOrderProductService;
import com.zbkj.service.service.PayComponentOrderService;
import com.zbkj.service.service.WechatVideoAftersaleService;
import com.zbkj.service.service.WechatVideoOrderService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayComponentOrderServiceImpl
extends ServiceImpl<PayComponentOrderDao, PayComponentOrder>
implements PayComponentOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PayComponentOrderServiceImpl.class);
    @Resource
    private PayComponentOrderDao dao;
    @Autowired
    private WechatVideoOrderService wechatVideoOrderService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PayComponentOrderProductService componentOrderProductService;
    @Autowired
    private WechatVideoAftersaleService wechatVideoAftersaleService;

    @Override
    public ShopOrderAddResultVo create(ShopOrderAddVo shopOrderAddVo) {
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - START shopOrderAddVo\uff1a" + JSON.toJSONString((Object)shopOrderAddVo));
        ShopOrderAddResultVo addResultVo = this.wechatVideoOrderService.shopOrderAdd(shopOrderAddVo);
        PayComponentOrder order = new PayComponentOrder();
        order.setOrderNo(shopOrderAddVo.getOutOrderId());
        order.setComponentOrderId(addResultVo.getOrderId());
        order.setOpenid(shopOrderAddVo.getOpenid());
        order.setPath(shopOrderAddVo.getPath());
        order.setOutUserId(shopOrderAddVo.getOutUserId());
        ShopOrderPayInfoAddVo payInfo = shopOrderAddVo.getOrderDetail().getPayInfo();
        order.setPayMethod(payInfo.getPayMethod());
        order.setPayMethodType(payInfo.getPayMethodType());
        order.setPrepayId(payInfo.getPrepayId());
        order.setPrepayTime(payInfo.getPrepayTime());
        ShopOrderPriceInfoVo priceInfo = shopOrderAddVo.getOrderDetail().getPriceInfo();
        order.setOrderPrice(priceInfo.getOrderPrice());
        order.setFreight(priceInfo.getFreight());
        order.setDiscountedPrice(priceInfo.getDiscountedPrice());
        order.setDeliveryType(shopOrderAddVo.getDeliveryDetail().getDeliveryType());
        ShopOrderAddressInfoAddVo addressInfo = shopOrderAddVo.getAddressInfo();
        order.setReceiverName(addressInfo.getReceiverName());
        order.setTelNumber(addressInfo.getTelNumber());
        order.setDetailedAddress(addressInfo.getDetailedAddress());
        order.setTicket(addResultVo.getTicket());
        order.setTicketExpireTime(addResultVo.getTicketExpireTime());
        order.setFinalPrice(Long.valueOf(priceInfo.getOrderPrice() + priceInfo.getFreight()));
        order.setStatus(Integer.valueOf(10));
        order.setFinishAllDelivery(Integer.valueOf(0));
        order.setCreateTime(CrmebDateUtil.strToDate((String)shopOrderAddVo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        order.setOutUserId(shopOrderAddVo.getOutUserId());
        order.setMerId(shopOrderAddVo.getMerId());
        List productInfos = shopOrderAddVo.getOrderDetail().getProductInfos();
        List orderProductList = productInfos.stream().map(productInfo -> {
            PayComponentOrderProduct orderProduct = new PayComponentOrderProduct();
            orderProduct.setOrderNo(order.getOrderNo());
            orderProduct.setComponentOrderId(order.getComponentOrderId());
            orderProduct.setOutProductId(productInfo.getOutProductId());
            orderProduct.setOutSkuId(productInfo.getOutSkuId());
            orderProduct.setProductCnt(productInfo.getProductCnt());
            orderProduct.setSalePrice(productInfo.getSalePrice());
            orderProduct.setHeadImg(productInfo.getHeadImg());
            orderProduct.setTitle(productInfo.getTitle());
            orderProduct.setPath(productInfo.getPath());
            orderProduct.setCreateTime(CrmebDateUtil.nowDateTime());
            return orderProduct;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.save(order);
            this.componentOrderProductService.saveBatch(orderProductList);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u4fdd\u5b58\u7ec4\u4ef6\u8ba2\u5355\u5931\u8d25");
        }
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 - START order\uff1a" + JSON.toJSONString((Object)order));
        return addResultVo;
    }

    @Override
    public PayComponentOrder getByOrderNo(String orderNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentOrder::getOrderNo, (Object)orderNo);
        return (PayComponentOrder)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public void createAfterSale(String orderNo) {
        PayComponentOrder order = this.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            this.log.error("\u89c6\u9891\u53f7\u8ba2\u5355\u521b\u5efa\u552e\u540e\u672a\u627e\u5230\u8ba2\u5355\uff0c\u8ba2\u5355\u7f16\u53f7=" + orderNo);
            return;
        }
        List<PayComponentOrderProduct> orderProductList = this.componentOrderProductService.getListByOrderNo(orderNo);
        ShopAftersaleAddVo shopAftersaleAddVo = new ShopAftersaleAddVo();
        shopAftersaleAddVo.setOutOrderId(orderNo);
        shopAftersaleAddVo.setOutAftersaleId(orderNo);
        shopAftersaleAddVo.setOpenid(order.getOpenid());
        shopAftersaleAddVo.setType(Integer.valueOf(1));
        shopAftersaleAddVo.setCreateTime(CrmebDateUtil.nowDate());
        shopAftersaleAddVo.setStatus(Integer.valueOf(2));
        shopAftersaleAddVo.setFinishAllAftersale(Integer.valueOf(0));
        shopAftersaleAddVo.setPath(StrUtil.format((CharSequence)"/pages/order_details/index?order_id={}&type={}", (Object[])new Object[]{orderNo, "video"}));
        List infoVoList = orderProductList.stream().map(product -> {
            AftersaleProductInfoVo infoVo = new AftersaleProductInfoVo();
            infoVo.setOutProductId(product.getOutProductId());
            infoVo.setOutSkuId(product.getOutSkuId());
            infoVo.setProductCnt(product.getProductCnt());
            return infoVo;
        }).collect(Collectors.toList());
        shopAftersaleAddVo.setProductInfos(infoVoList);
        Boolean add = this.wechatVideoAftersaleService.shopAftersaleAdd(shopAftersaleAddVo);
        if (!add.booleanValue()) {
            this.log.error("\u89c6\u9891\u53f7\u8ba2\u5355\u521b\u5efa\u552e\u540e\u5931\u8d25\uff0corderNo=" + orderNo);
            throw new CrmebException("\u89c6\u9891\u53f7\u8ba2\u5355\u521b\u5efa\u552e\u540e\u5931\u8d25\uff0corderNo=" + orderNo);
        }
        ShopAftersaleUpdateVo updateVo = new ShopAftersaleUpdateVo();
        updateVo.setOutOrderId(orderNo);
        updateVo.setOpenid(order.getOpenid());
        updateVo.setOutAftersaleId(orderNo);
        updateVo.setStatus(Integer.valueOf(13));
        updateVo.setFinishAllAftersale(Integer.valueOf(1));
        Boolean update = this.wechatVideoAftersaleService.shopAftersaleUpdate(updateVo);
        if (!update.booleanValue()) {
            this.log.error("\u89c6\u9891\u53f7\u8ba2\u5355\u66f4\u65b0\u552e\u540e\u5931\u8d25\uff0corderNo=" + orderNo);
            throw new CrmebException("\u89c6\u9891\u53f7\u8ba2\u5355\u66f4\u65b0\u552e\u540e\u5931\u8d25\uff0corderNo=" + orderNo);
        }
    }
}

