package com.zbkj.admin.task.brokerage;


import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.service.service.BcxSettleBillService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;

/**
 * description：生成业绩账单定时器
 * author：linchunpeng
 * date：2023/10/30
 */
@Component("GenerateSettleBillTask")
public class GenerateSettleBillTask {

    private static final Logger logger = LoggerFactory.getLogger(GenerateSettleBillTask.class);

    @Autowired
    private BcxSettleBillService bcxSettleBillService;

    public GenerateSettleBillTask(){
        logger.error("cccccccc");
    }

    public void generateSettleBill() {
        logger.info("---GenerateSettleBillTask task------: Execution Time - {}", CrmebDateUtil.nowDateTime());
        //取上个月的最后一天的23:59:59
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        bcxSettleBillService.generateSettleBill(new Date(calendar.getTime().getTime()-1000));
    }

}
