package com.zbkj.admin.controller.platform;

import cn.hutool.core.collection.CollectionUtil;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.annotation.LogControllerAnnotation;
import com.zbkj.common.enums.MethodType;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.OrderSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.RefundOrderRemarkRequest;
import com.zbkj.common.request.RefundOrderSearchRequest;
import com.zbkj.common.request.bcx.BcxOrderFapiaoQueryRequest;
import com.zbkj.common.response.PlatformRefundOrderPageResponse;
import com.zbkj.common.response.RefundOrderAdminDetailResponse;
import com.zbkj.common.response.RefundOrderCountItemResponse;
import com.zbkj.common.response.bcx.BcxOrderFapiaoResponse;
import com.zbkj.common.response.bcx.BcxOrderSummaryInfo;
import com.zbkj.common.result.CommonResult;
import com.zbkj.common.utils.ExportUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.service.RefundOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 平台端退款订单控制器
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Slf4j
@RestController
@RequestMapping("api/admin/platform/refund/order")
@Api(tags = "平台端退款订单控制器")
public class PlatformRefundOrderController {

    @Autowired
    private RefundOrderService refundOrderService;

    @PreAuthorize("hasAuthority('platform:refund:order:page:list')")
    @ApiOperation(value = "平台端退款订单分页列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<PlatformRefundOrderPageResponse>> getList(@Validated RefundOrderSearchRequest request, @Validated PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(refundOrderService.getPlatformAdminPageSql(request, pageParamRequest)));
    }

    @PreAuthorize("hasAuthority('platform:refund:order:status:num')")
    @ApiOperation(value = "平台端获取退款订单各状态数量")
    @RequestMapping(value = "/status/num", method = RequestMethod.GET)
    public CommonResult<RefundOrderCountItemResponse> getOrderStatusNum(@RequestParam(value = "dateLimit", defaultValue = "") String dateLimit) {
        return CommonResult.success(refundOrderService.getPlatformOrderStatusNum(dateLimit));
    }

    //@PreAuthorize("hasAuthority('platform:order:status:num')")
    @ApiOperation(value = "平台端获取退款单统计数据")
    @RequestMapping(value = "/summary", method = RequestMethod.GET)
    public CommonResult<BcxOrderSummaryInfo> getRefundOrderSummary(@Validated RefundOrderSearchRequest request) {
        return CommonResult.success(refundOrderService.getSummaryOrderInfo(request));
    }
    @ApiOperation(value = "平台端退款单查询-导出excel")
    //@PreAuthorize("hasAuthority('merchant:attachment:list')")
    @RequestMapping(value = "/list/excel", method = {RequestMethod.POST})
    public void queryFapiaoListExcel(@RequestBody @Validated RefundOrderSearchRequest request, HttpServletResponse response) {
        //获取导出excel表格的数据列表
        PageParamRequest pageParamRequest = new PageParamRequest();
        pageParamRequest.setPage(1);
        pageParamRequest.setLimit(65500);
        PageInfo<PlatformRefundOrderPageResponse> result = refundOrderService.getPlatformAdminPageSql(request, pageParamRequest);
        ExportUtil<PlatformRefundOrderPageResponse> exportUtil = new ExportUtil<>();
        exportUtil.export("退款单列表", result.getList(), response);
    }
    @PreAuthorize("hasAuthority('platform:refund:order:detail')")
    @ApiOperation(value = "平台端退款订单详情")
    @RequestMapping(value = "/detail/{refundOrderNo}", method = RequestMethod.GET)
    public CommonResult<RefundOrderAdminDetailResponse> getDetail(@PathVariable(value = "refundOrderNo") String refundOrderNo) {
        return CommonResult.success(refundOrderService.getPlatformDetail(refundOrderNo));
    }

    @LogControllerAnnotation(intoDB = true, methodType = MethodType.UPDATE, description = "平台备注退款订单")
    @PreAuthorize("hasAuthority('platform:refund:order:mark')")
    @ApiOperation(value = "平台备注退款订单")
    @RequestMapping(value = "/mark", method = RequestMethod.POST)
    public CommonResult<String> mark(@RequestBody @Validated RefundOrderRemarkRequest request) {
        if (refundOrderService.platformMark(request)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

}



