/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.zbkj.common.constants.BillConstants;
import com.zbkj.common.constants.BrokerageRecordConstants;
import com.zbkj.common.constants.IntegralRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bill.Bill;
import com.zbkj.common.model.bill.MerchantBill;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.OrderProfitSharing;
import com.zbkj.common.model.order.RefundOrder;
import com.zbkj.common.model.order.RefundOrderInfo;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.seckill.SeckillProduct;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserBrokerageRecord;
import com.zbkj.common.model.user.UserIntegralRecord;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BillService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantBillService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderProfitSharingService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.OrderStatusService;
import com.zbkj.service.service.OrderTaskService;
import com.zbkj.service.service.PayService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.RefundOrderInfoService;
import com.zbkj.service.service.RefundOrderService;
import com.zbkj.service.service.SeckillProductService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserBrokerageRecordService;
import com.zbkj.service.service.UserIntegralRecordService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import com.zbkj.service.service.bcx.BcxPayOfflineService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class OrderTaskServiceImpl
implements OrderTaskService {
    private static final Logger logger = LoggerFactory.getLogger(OrderTaskServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderStatusService orderStatusService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private UserService userService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private PayService payService;
    @Autowired
    private RefundOrderService refundOrderService;
    @Autowired
    private RefundOrderInfoService refundOrderInfoService;
    @Autowired
    private UserIntegralRecordService userIntegralRecordService;
    @Autowired
    private UserBrokerageRecordService userBrokerageRecordService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private OrderProfitSharingService orderProfitSharingService;
    @Autowired
    private MerchantBillService merchantBillService;
    @Autowired
    private BillService billService;
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private SeckillProductService seckillProductService;
    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Resource
    private BcxFapiaoSourceService bcxFapiaoSourceService;
    @Resource
    private BcxPayOfflineService bcxPayOfflineService;

    @Override
    public void cancelByUser() {
        String redisKey = "alterOrderCancelByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.cancelByUser | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    boolean result = this.userCancelOrder(String.valueOf(data));
                    if (!result) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean userCancelOrder(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        if (!order.getStatus().equals(OrderConstants.ORDER_STATUS_CANCEL)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u72b6\u6001\u8be5\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_NORMAL)) {
            logger.error("\u7528\u6237\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u72b6\u6001\u53d6\u6d88\u5f02\u5e38\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.FALSE;
        }
        if (order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_SYSTEM)) {
            return Boolean.TRUE;
        }
        User user = (User)this.userService.getById(order.getUid());
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(order.getOrderNo());
        List couponIdList = merchantOrderList.stream().filter(e -> e.getCouponId() > 0).map(MerchantOrder::getCouponId).collect(Collectors.toList());
        if (order.getPlatCouponId() > 0) {
            couponIdList.add(order.getPlatCouponId());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean rollbackStock;
            this.orderStatusService.createLog(orderNo, "cancel_order", "\u7528\u6237\u53d6\u6d88\u8ba2\u5355");
            if (CollUtil.isNotEmpty((Collection)couponIdList)) {
                this.couponUserService.rollbackByIds(couponIdList);
            }
            if (order.getUseIntegral() > 0) {
                this.userService.updateIntegral(order.getUid(), order.getUseIntegral(), "add");
                UserIntegralRecord userIntegralRecord = this.initOrderCancelIntegralRecord(user.getId(), order.getUseIntegral(), user.getIntegral(), order.getOrderNo());
                this.userIntegralRecordService.save(userIntegralRecord);
            }
            if (!(rollbackStock = this.rollbackStock(order)).booleanValue()) {
                e.setRollbackOnly();
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private UserIntegralRecord initOrderCancelIntegralRecord(Integer uid, Integer useIntegral, Integer integral, String orderNo) {
        UserIntegralRecord integralRecord = new UserIntegralRecord();
        integralRecord.setUid(uid);
        integralRecord.setLinkId(orderNo);
        integralRecord.setLinkType("order");
        integralRecord.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        integralRecord.setTitle(StrUtil.format((CharSequence)"\u8ba2\u5355\u53d6\u6d88\uff0c\u9000\u56de\u91d1\u989d\u62b5\u6263\u79ef\u5206\uff1a{}", (Object[])new Object[]{useIntegral}));
        integralRecord.setIntegral(useIntegral);
        integralRecord.setBalance(Integer.valueOf(integral + useIntegral));
        integralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return integralRecord;
    }

    @Override
    public void orderRefund() {
        String redisKey = "alterOrderRefundByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderRefund | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object orderNoData = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)orderNoData)) {
                try {
                    Boolean result = this.refundAfterProcessing(orderNoData.toString());
                    if (!result.booleanValue()) {
                        this.redisUtil.lPush(redisKey, orderNoData);
                    }
                }
                catch (Exception e) {
                    logger.error("\u8ba2\u5355\u9000\u6b3e\u9519\u8bef\uff1a" + e.getMessage());
                    this.redisUtil.lPush(redisKey, orderNoData);
                }
            }
            ++i;
        }
    }

    private Boolean refundAfterProcessing(String refundOrderNo) {
        BigDecimal platRefundPayPrice;
        BigDecimal merRefundPayPrice;
        OrderProfitSharing orderProfitSharing;
        UserIntegralRecord gainIntegralRecord;
        RefundOrder refundOrder = this.refundOrderService.getInfoException(refundOrderNo);
        if (!refundOrder.getRefundStatus().equals(OrderConstants.MERCHANT_REFUND_ORDER_STATUS_REFUND)) {
            throw new CrmebException("\u9000\u6b3e\u5355\u72b6\u6001\u5f02\u5e38");
        }
        Order order = this.orderService.getByOrderNo(refundOrder.getOrderNo());
        String orderNo = order.getOrderNo();
        RefundOrderInfo refundOrderInfo = this.refundOrderInfoService.getByRefundOrderNo(refundOrderNo);
        ArrayList integralRecordAddList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        ArrayList integralRecordUpdateList = CollUtil.newArrayList((Object[])new UserIntegralRecord[0]);
        if (refundOrder.getRefundUseIntegral() > 0) {
            UserIntegralRecord userIntegralRecord = this.refundUseIntegralRecordInit(refundOrder, refundOrderInfo);
            integralRecordAddList.add(userIntegralRecord);
        }
        if (refundOrder.getRefundGainIntegral() > 0 && (gainIntegralRecord = this.userIntegralRecordService.getByOrderNoAndType(orderNo, IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD)).getStatus() < IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE) {
            if (gainIntegralRecord.getIntegral().equals(refundOrder.getRefundGainIntegral())) {
                gainIntegralRecord.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_INVALIDATION);
                gainIntegralRecord.setUpdateTime((Date)DateUtil.date());
            } else {
                gainIntegralRecord.setIntegral(Integer.valueOf(gainIntegralRecord.getIntegral() - refundOrder.getRefundGainIntegral()));
                gainIntegralRecord.setUpdateTime((Date)DateUtil.date());
            }
            integralRecordUpdateList.add(gainIntegralRecord);
        }
        ArrayList brokerageRecordList = CollUtil.newArrayList((Object[])new UserBrokerageRecord[0]);
        List<UserBrokerageRecord> userBrokerageRecordList = this.userBrokerageRecordService.getByOrderNo(orderNo);
        if (CollUtil.isNotEmpty(userBrokerageRecordList) && userBrokerageRecordList.get(0).getStatus() < BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_COMPLETE) {
            userBrokerageRecordList.forEach(r -> {
                if (r.getBrokerageLevel().equals(1)) {
                    if (r.getPrice().compareTo(refundOrderInfo.getRefundFirstBrokerageFee()) == 0) {
                        r.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_INVALIDATION);
                    } else {
                        r.setPrice(r.getPrice().subtract(refundOrderInfo.getRefundFirstBrokerageFee()));
                    }
                }
                if (r.getBrokerageLevel().equals(2)) {
                    if (r.getPrice().compareTo(refundOrderInfo.getRefundSecondBrokerageFee()) == 0) {
                        r.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_INVALIDATION);
                    } else {
                        r.setPrice(r.getPrice().subtract(refundOrderInfo.getRefundSecondBrokerageFee()));
                    }
                }
                brokerageRecordList.add(r);
            });
        }
        if ((orderProfitSharing = this.orderProfitSharingService.getByOrderNo(orderNo)).getOrderPrice().compareTo(refundOrder.getRefundPrice()) == 0) {
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice();
            platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice();
        } else if (orderProfitSharing.getOrderPrice().subtract(orderProfitSharing.getProfitSharingRefund()).compareTo(refundOrder.getRefundPrice()) == 0) {
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().subtract(orderProfitSharing.getRefundProfitSharingMerPrice());
            platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().subtract(orderProfitSharing.getRefundProfitSharingPlatPrice());
        } else {
            BigDecimal payReRatio = refundOrder.getRefundPrice().divide(orderProfitSharing.getOrderPrice(), 2, 4);
            merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().multiply(payReRatio).setScale(2, 4);
            if (merRefundPayPrice.add(orderProfitSharing.getRefundProfitSharingMerPrice()).compareTo(orderProfitSharing.getProfitSharingMerPrice()) > 0) {
                merRefundPayPrice = orderProfitSharing.getProfitSharingMerPrice().subtract(orderProfitSharing.getRefundProfitSharingMerPrice());
            }
            if ((platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().multiply(payReRatio).setScale(2, 4)).add(orderProfitSharing.getRefundProfitSharingPlatPrice()).compareTo(orderProfitSharing.getProfitSharingPlatPrice()) > 0) {
                platRefundPayPrice = orderProfitSharing.getProfitSharingPlatPrice().subtract(orderProfitSharing.getRefundProfitSharingPlatPrice());
            }
        }
        orderProfitSharing.setRefundProfitSharingMerPrice(orderProfitSharing.getRefundProfitSharingMerPrice().add(merRefundPayPrice));
        orderProfitSharing.setRefundProfitSharingPlatPrice(orderProfitSharing.getRefundProfitSharingPlatPrice().add(platRefundPayPrice));
        if (refundOrder.getRefundPlatCouponPrice().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundPlatCouponPrice(orderProfitSharing.getRefundPlatCouponPrice().add(refundOrder.getRefundPlatCouponPrice()));
        }
        if (refundOrder.getRefundFirstBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundFirstBrokerageFee(orderProfitSharing.getRefundFirstBrokerageFee().add(refundOrder.getRefundFirstBrokerageFee()));
        }
        if (refundOrder.getRefundSecondBrokerageFee().compareTo(BigDecimal.ZERO) > 0) {
            orderProfitSharing.setRefundSecondBrokerageFee(orderProfitSharing.getRefundSecondBrokerageFee().add(refundOrder.getRefundSecondBrokerageFee()));
        }
        if (refundOrderInfo.getRefundUseIntegral() > 0) {
            orderProfitSharing.setRefundUseIntegral(Integer.valueOf(orderProfitSharing.getRefundUseIntegral() + refundOrderInfo.getRefundUseIntegral()));
            orderProfitSharing.setRefundIntegralPrice(orderProfitSharing.getRefundIntegralPrice().add(refundOrderInfo.getRefundIntegralPrice()));
        }
        refundOrder.setMerchantRefundPrice(merRefundPayPrice);
        refundOrder.setPlatformRefundPrice(platRefundPayPrice);
        if (CollUtil.isEmpty((Collection)brokerageRecordList)) {
            refundOrder.setIsReplace(Boolean.valueOf(true));
        }
        MerchantBill merchantBill = this.initMerchantBillRefund(refundOrder);
        Bill platBill = new Bill();
        platBill.setOrderNo(refundOrder.getRefundOrderNo());
        platBill.setMerId(refundOrder.getMerId());
        platBill.setPm(BillConstants.BILL_PM_SUB);
        platBill.setAmount(platRefundPayPrice);
        platBill.setType("refund_order");
        platBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u8fd4\u8fd8\u5206\u8d26\u91d1\u989d{}\u5143", (Object[])new Object[]{platRefundPayPrice}));
        orderProfitSharing.setProfitSharingRefund(orderProfitSharing.getProfitSharingRefund().add(refundOrder.getRefundPrice()));
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.refundRollbackStock(refundOrderInfo, order.getType());
            this.merchantService.operationBalance(refundOrder.getMerId(), refundOrder.getMerchantRefundPrice(), "sub");
            this.merchantBillService.save(merchantBill);
            this.refundOrderService.updateById(refundOrder);
            if (CollUtil.isNotEmpty((Collection)integralRecordAddList)) {
                this.userIntegralRecordService.saveBatch(integralRecordAddList);
            }
            if (CollUtil.isNotEmpty((Collection)integralRecordUpdateList)) {
                this.userIntegralRecordService.updateBatchById(integralRecordUpdateList);
            }
            if (CollUtil.isNotEmpty((Collection)brokerageRecordList)) {
                this.userBrokerageRecordService.updateBatchById(brokerageRecordList);
            } else {
                BigDecimal platReplacePrice = refundOrderInfo.getRefundFirstBrokerageFee().add(refundOrderInfo.getRefundSecondBrokerageFee());
                Bill bill = new Bill();
                bill.setOrderNo(refundOrder.getRefundOrderNo());
                bill.setMerId(refundOrder.getMerId());
                bill.setPm(BillConstants.BILL_PM_SUB);
                bill.setAmount(platReplacePrice);
                bill.setType("refund_order");
                bill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u4ee3\u6263\u4f63\u91d1\u5e94\u9000\u91d1\u989d{}\u5143", (Object[])new Object[]{platReplacePrice}));
                this.billService.save(bill);
            }
            if (refundOrderInfo.getRefundUseIntegral() > 0) {
                this.userService.updateIntegral(refundOrder.getUid(), refundOrderInfo.getRefundUseIntegral(), "add");
                Bill bill = new Bill();
                bill.setOrderNo(refundOrder.getRefundOrderNo());
                bill.setMerId(refundOrder.getMerId());
                bill.setPm(BillConstants.BILL_PM_ADD);
                bill.setAmount(refundOrderInfo.getRefundIntegralPrice());
                bill.setType("refund_order");
                bill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u5e73\u53f0\u4ee3\u6263\u79ef\u5206\u62b5\u6263\u91d1\u989d\u8fd4\u8fd8{}\u5143", (Object[])new Object[]{refundOrderInfo.getRefundIntegralPrice()}));
                this.billService.save(bill);
            }
            this.billService.save(platBill);
            this.orderProfitSharingService.updateById(orderProfitSharing);
            return Boolean.TRUE;
        });
    }

    private MerchantBill initMerchantBillRefund(RefundOrder refundOrder) {
        MerchantBill merchantBill = new MerchantBill();
        merchantBill.setMerId(refundOrder.getMerId());
        merchantBill.setType("refund_order");
        merchantBill.setOrderNo(refundOrder.getRefundOrderNo());
        merchantBill.setUid(refundOrder.getUid());
        merchantBill.setPm(BillConstants.BILL_PM_SUB);
        merchantBill.setAmount(refundOrder.getMerchantRefundPrice());
        merchantBill.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355{}\u9000\u6b3e{}\u5143\uff0c\u5546\u6237\u652f\u51fa{}\u5143", (Object[])new Object[]{refundOrder.getOrderNo(), refundOrder.getRefundPrice(), refundOrder.getMerchantRefundPrice()}));
        return merchantBill;
    }

    private void refundRollbackStock(RefundOrderInfo refundOrderInfo, Integer orderType) {
        if (orderType.equals(OrderConstants.ORDER_TYPE_SECKILL)) {
            this.seckillProductService.operationStock(refundOrderInfo.getProductId(), refundOrderInfo.getApplyRefundNum(), "add");
            String seckillProductQuotaKey = StrUtil.format((CharSequence)"seckill_product_quota:{}", (Object[])new Object[]{refundOrderInfo.getProductId()});
            String seckillProductSkuQuotaKey = StrUtil.format((CharSequence)"seckill_product_sku_quota:{}", (Object[])new Object[]{refundOrderInfo.getAttrValueId()});
            this.redisUtil.incrAndCreate(seckillProductQuotaKey, (long)refundOrderInfo.getApplyRefundNum().intValue());
            this.redisUtil.incrAndCreate(seckillProductSkuQuotaKey, (long)refundOrderInfo.getApplyRefundNum().intValue());
        } else {
            this.productService.operationStock(refundOrderInfo.getProductId(), refundOrderInfo.getApplyRefundNum(), "add");
        }
        ProductAttrValue attrValue = (ProductAttrValue)this.productAttrValueService.getById(refundOrderInfo.getAttrValueId());
        this.productAttrValueService.operationStock(attrValue.getId(), refundOrderInfo.getApplyRefundNum(), "add", attrValue.getType(), attrValue.getVersion());
    }

    private UserIntegralRecord refundUseIntegralRecordInit(RefundOrder refundOrder, RefundOrderInfo refundOrderInfo) {
        UserIntegralRecord record = new UserIntegralRecord();
        record.setUid(refundOrder.getUid());
        record.setLinkId(refundOrder.getRefundOrderNo());
        record.setLinkType("refund");
        record.setType(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD);
        record.setTitle("\u8ba2\u5355\u9000\u6b3e");
        record.setIntegral(refundOrderInfo.getRefundUseIntegral());
        record.setMark(StrUtil.format((CharSequence)"\u8ba2\u5355\u9000\u6b3e\uff0c\u8fd4\u8fd8\u652f\u4ed8\u4f7f\u7528\u7684{}\u79ef\u5206", (Object[])new Object[]{record.getIntegral()}));
        record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_COMPLETE);
        return record;
    }

    @Override
    public void orderPaySuccessAfter() {
        String redisKey = "orderPaySuccessTask";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderPaySuccessAfter | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    Boolean result = this.payService.payAfterProcessingTemp(String.valueOf(data));
                    if (!result.booleanValue()) {
                        logger.error("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u540e\u7f6e\u5904\u7406\u5931\u8d25\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)String.valueOf(data));
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    logger.error("order pay task error exception : {}", (Object)e.getMessage());
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    @Override
    public void autoCancel() {
        String redisKey = "order_auto_cancel_key";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.autoCancel | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    boolean result = this.orderAutoCancel(String.valueOf(data));
                    if (!result) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean orderAutoCancel(String orderNo) {
        DateTime cancelTime;
        long between;
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u81ea\u52a8\u53d6\u6d88\u652f\u4ed8\u8ba2\u5355\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderNo);
            return Boolean.TRUE;
        }
        if (order.getPaid().booleanValue()) {
            return Boolean.TRUE;
        }
        if (order.getStatus().equals(OrderConstants.ORDER_STATUS_CANCEL)) {
            return Boolean.TRUE;
        }
        if (!order.getCancelStatus().equals(OrderConstants.ORDER_CANCEL_STATUS_NORMAL)) {
            return Boolean.TRUE;
        }
        if (order.getPayType().equals("offline")) {
            return Boolean.FALSE;
        }
        String cancelStr = this.systemConfigService.getValueByKey("order_cancel_time");
        if (StrUtil.isBlank((CharSequence)cancelStr)) {
            cancelStr = "5";
        }
        if ((between = DateUtil.between((Date)(cancelTime = DateUtil.offset((Date)order.getCreateTime(), (DateField)DateField.MINUTE, (int)Integer.parseInt(cancelStr))), (Date)DateUtil.date(), (DateUnit)DateUnit.SECOND, (boolean)false)) < 0L) {
            return Boolean.FALSE;
        }
        User user = (User)this.userService.getById(order.getUid());
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(order.getOrderNo());
        List couponIdList = merchantOrderList.stream().filter(e -> e.getCouponId() > 0).map(MerchantOrder::getCouponId).collect(Collectors.toList());
        if (order.getPlatCouponId() > 0) {
            couponIdList.add(order.getPlatCouponId());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean rollbackStock;
            this.orderService.cancel(order.getOrderNo(), false);
            this.orderStatusService.createLog(order.getOrderNo(), "cancel", "\u5230\u671f\u672a\u652f\u4ed8\u7cfb\u7edf\u81ea\u52a8\u53d6\u6d88");
            if (CollUtil.isNotEmpty((Collection)couponIdList)) {
                this.couponUserService.rollbackByIds(couponIdList);
            }
            if (order.getUseIntegral() > 0) {
                this.userService.updateIntegral(order.getUid(), order.getUseIntegral(), "add");
                UserIntegralRecord userIntegralRecord = this.initOrderCancelIntegralRecord(user.getId(), order.getUseIntegral(), user.getIntegral(), order.getOrderNo());
                this.userIntegralRecordService.save(userIntegralRecord);
            }
            if (!(rollbackStock = this.rollbackStock(order)).booleanValue()) {
                e.setRollbackOnly();
                logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u5931\u8d25,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private Boolean rollbackStock(Order order) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        if (CollUtil.isEmpty(orderDetailList)) {
            logger.error("\u8ba2\u5355\u56de\u6eda\u5e93\u5b58\u672a\u627e\u5230\u5546\u54c1\u8be6\u60c5,\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
            return false;
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            for (OrderDetail orderDetail : orderDetailList) {
                ProductAttrValue productAttrValue;
                if (order.getType().equals(OrderConstants.ORDER_TYPE_SECKILL)) {
                    SeckillProduct seckillProduct = (SeckillProduct)this.seckillProductService.getById(orderDetail.getProductId());
                    if (ObjectUtil.isNotNull((Object)seckillProduct)) {
                        this.seckillProductService.operationStock(seckillProduct.getId(), orderDetail.getPayNum(), "add");
                    }
                    String seckillProductQuotaKey = StrUtil.format((CharSequence)"seckill_product_quota:{}", (Object[])new Object[]{orderDetail.getProductId()});
                    String seckillProductSkuQuotaKey = StrUtil.format((CharSequence)"seckill_product_sku_quota:{}", (Object[])new Object[]{orderDetail.getAttrValueId()});
                    this.redisUtil.incrAndCreate(seckillProductQuotaKey, (long)orderDetail.getPayNum().intValue());
                    this.redisUtil.incrAndCreate(seckillProductSkuQuotaKey, (long)orderDetail.getPayNum().intValue());
                } else {
                    Product product = (Product)this.productService.getById(orderDetail.getProductId());
                    if (ObjectUtil.isNotNull((Object)product)) {
                        this.productService.operationStock(product.getId(), orderDetail.getPayNum(), "add");
                    }
                }
                if (!ObjectUtil.isNotNull((Object)(productAttrValue = (ProductAttrValue)this.productAttrValueService.getById(orderDetail.getAttrValueId())))) continue;
                this.productAttrValueService.operationStock(productAttrValue.getId(), orderDetail.getPayNum(), "add", productAttrValue.getType(), productAttrValue.getVersion());
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public void orderReceiving() {
        String redisKey = "alterOrderTakeByUser";
        Long size = this.redisUtil.getListSize(redisKey);
        logger.info("OrderTaskServiceImpl.orderReceiving | size:" + size);
        if (size < 1L) {
            return;
        }
        int i = 0;
        while ((long)i < size) {
            Object data = this.redisUtil.getRightPop(redisKey, Long.valueOf(10L));
            if (!ObjectUtil.isNull((Object)data)) {
                try {
                    Boolean result = this.takeDeliveryAfter(String.valueOf(data));
                    if (!result.booleanValue()) {
                        this.redisUtil.lPush(redisKey, data);
                    }
                }
                catch (Exception e) {
                    this.redisUtil.lPush(redisKey, data);
                }
            }
            ++i;
        }
    }

    private Boolean takeDeliveryAfter(String orderNo) {
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            logger.error("\u8ba2\u5355\u6536\u8d27task\u5904\u7406\uff0c\u672a\u627e\u5230\u8ba2\u5355\uff0corderNo={}", (Object)orderNo);
            return Boolean.FALSE;
        }
        User user = (User)this.userService.getById(order.getUid());
        List<UserBrokerageRecord> recordList = this.userBrokerageRecordService.findListByLinkNoAndLinkType(orderNo, "order");
        logger.info("\u6536\u8d27\u5904\u7406\u4f63\u91d1\u6761\u6570\uff1a" + recordList.size());
        for (UserBrokerageRecord record : recordList) {
            if (!record.getStatus().equals(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_CREATE)) {
                throw new CrmebException(StrUtil.format((CharSequence)"\u8ba2\u5355\u6536\u8d27task\u5904\u7406\uff0c\u8ba2\u5355\u4f63\u91d1\u8bb0\u5f55\u4e0d\u662f\u521b\u5efa\u72b6\u6001\uff0corderNo={}", (Object[])new Object[]{orderNo}));
            }
            record.setStatus(BrokerageRecordConstants.BROKERAGE_RECORD_STATUS_FROZEN);
            long thawTime = DateUtil.current((boolean)false);
            if (record.getFrozenTime() > 0) {
                DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
                thawTime = dateTime.getTime();
            }
            record.setThawTime(Long.valueOf(thawTime));
        }
        List<UserIntegralRecord> integralRecordList = this.userIntegralRecordService.findListByOrderNoAndUid(orderNo, order.getUid());
        logger.info("\u6536\u8d27\u5904\u7406\u79ef\u5206\u6761\u6570\uff1a" + integralRecordList.size());
        List userIntegralRecordList = integralRecordList.stream().filter(e -> e.getType().equals(IntegralRecordConstants.INTEGRAL_RECORD_TYPE_ADD)).collect(Collectors.toList());
        for (UserIntegralRecord record : userIntegralRecordList) {
            if (!record.getStatus().equals(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_CREATE)) {
                throw new CrmebException(StrUtil.format((CharSequence)"\u8ba2\u5355\u6536\u8d27task\u5904\u7406\uff0c\u8ba2\u5355\u79ef\u5206\u8bb0\u5f55\u4e0d\u662f\u521b\u5efa\u72b6\u6001\uff0corderNo={}", (Object[])new Object[]{orderNo}));
            }
            record.setStatus(IntegralRecordConstants.INTEGRAL_RECORD_STATUS_FROZEN);
            long thawTime = DateUtil.current((boolean)false);
            if (record.getFrozenTime() > 0) {
                DateTime dateTime = DateUtil.offsetDay((Date)new Date(), (int)record.getFrozenTime());
                thawTime = dateTime.getTime();
            }
            record.setThawTime(Long.valueOf(thawTime));
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.orderStatusService.createLog(order.getOrderNo(), "user_take_delivery", "\u7528\u6237\u5df2\u6536\u8d27");
            if (CollUtil.isNotEmpty((Collection)recordList)) {
                this.userBrokerageRecordService.updateBatchById(recordList);
            }
            if (CollUtil.isNotEmpty((Collection)userIntegralRecordList)) {
                this.userIntegralRecordService.updateBatchById(userIntegralRecordList);
            }
            return Boolean.TRUE;
        });
        if (execute.booleanValue()) {
            this.pushMessageOrder(order, user);
        }
        return execute;
    }

    @Override
    public void autoComplete() {
        Integer autoCompleteDay = Integer.parseInt(this.systemConfigService.getValueByKey("auto_complete_day"));
        List<Order> orderList = this.orderService.findCanCompleteOrder(autoCompleteDay);
        if (CollUtil.isEmpty(orderList)) {
            logger.info("OrderTaskServiceImpl.autoComplete | size:0");
            return;
        }
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).collect(Collectors.toList());
        orderNoList.forEach(orderNo -> {
            Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
                try {
                    Order order = this.orderService.getByOrderNo((String)orderNo);
                    this.orderService.completeByOrderNo((String)orderNo);
                    this.bcxFapiaoSourceService.saveSourceFromOrder((String)orderNo);
                    if (order.getPayType().equals("wallet") || order.getPayType().equals("weixin2huifu")) {
                        User user = (User)this.userService.getById(order.getUid());
                        Merchant merchant = (Merchant)this.merchantService.getById(order.getMerId());
                        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo((String)orderNo);
                        this.payService.walletUnfreezeAndPay(order, orderDetails, order.getBizType(), user, merchant);
                    } else if (order.getPayType().equals("offline")) {
                        User user = (User)this.userService.getById(order.getUid());
                        Merchant merchant = (Merchant)this.merchantService.getById(order.getMerId());
                        List<OrderDetail> orderDetails = this.orderDetailService.getByOrderNo((String)orderNo);
                        this.payService.platWalletUnfreezeAndPay(order, orderDetails, order.getBizType(), user, merchant);
                    } else {
                        logger.info(" TODO ...");
                    }
                    this.orderStatusService.createLog((String)orderNo, "complete", "\u8ba2\u5355\u5df2\u5b8c\u6210");
                }
                catch (Exception ex) {
                    e.setRollbackOnly();
                    logger.error("\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\u51fa\u9519\uff1a", (Throwable)ex);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            });
            if (Boolean.FALSE.equals(execute)) {
                logger.error("\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\uff1a\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\uff0corderNo = {}", orderNo);
            } else {
                logger.error("\u8ba2\u5355\u81ea\u52a8\u5b8c\u6210\uff1a\u66f4\u65b0\u6570\u636e\u5e93\u6210\u529f\uff0corderNo = {}", orderNo);
                this.bcxPerformanceReportService.frozenByOrder((String)orderNo);
            }
        });
    }

    private void pushMessageOrder(Order order, User user) {
        SystemNotification notification = this.systemNotificationService.getByMark("receiptGoods");
        if (order.getPayChannel().equals("h5")) {
            return;
        }
        if (!order.getPayType().equals("weixin")) {
            return;
        }
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (order.getPayChannel().equals("public") && notification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u60a8\u8d2d\u4e70\u7684\u5546\u54c1\u5df2\u786e\u8ba4\u6536\u8d27\uff01");
            temMap.put("keyword1", order.getOrderNo());
            temMap.put("keyword2", "\u5df2\u6536\u8d27");
            temMap.put("keyword3", CrmebDateUtil.nowDateTimeStr());
            temMap.put("keyword4", "\u8be6\u60c5\u8bf7\u8fdb\u5165\u8ba2\u5355\u67e5\u770b");
            temMap.put("remark", "\u611f\u8c22\u4f60\u7684\u4f7f\u7528\u3002");
            this.templateMessageService.pushTemplateMessage(notification.getWechatId(), temMap, userToken.getToken());
        } else if (notification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            List<OrderDetail> orderInvoiceDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
            List productNameList = orderInvoiceDetailList.stream().map(OrderDetail::getProductName).collect(Collectors.toList());
            String storeNameAndCarNumString = String.join((CharSequence)",", productNameList);
            if (StrUtil.isBlank((CharSequence)storeNameAndCarNumString)) {
                return;
            }
            if (storeNameAndCarNumString.length() > 20) {
                storeNameAndCarNumString = storeNameAndCarNumString.substring(0, 15) + "***";
            }
            temMap.put("character_string6", order.getOrderNo());
            temMap.put("date5", CrmebDateUtil.nowDateTimeStr());
            temMap.put("thing2", storeNameAndCarNumString);
            this.templateMessageService.pushMiniTemplateMessage(notification.getRoutineId(), temMap, userToken.getToken());
        }
    }

    @Override
    public void autoTakeDelivery() {
        DateTime nowDate;
        DateTime dateTime;
        List<Order> orderList;
        int day = 14;
        String autoDay = this.systemConfigService.getValueByKey("auto_take_delivery_day");
        if (StrUtil.isNotBlank((CharSequence)autoDay) && Integer.parseInt(autoDay) >= 1) {
            day = Integer.parseInt(autoDay);
        }
        if (CollUtil.isEmpty(orderList = this.orderService.findAwaitTakeDeliveryOrderList((dateTime = DateUtil.offsetDay((Date)(nowDate = DateUtil.date()), (int)(-day))).toString()))) {
            return;
        }
        orderList.forEach(order -> {
            if (order.getType().equals(1)) {
                // empty if block
            }
        });
        orderList.removeIf(order -> Objects.equals(order.getBizType(), ProductConstants.BIZ_TYPE_SPACIAL));
        orderList.removeIf(order -> {
            if ("offline".equalsIgnoreCase(order.getPayType())) {
                BcxPayOffline offline = this.bcxPayOfflineService.queryByOrderNo(order.getOrderNo());
                return offline.getStatus() != 3;
            }
            return false;
        });
        List<String> orderNoList = orderList.stream().map(Order::getOrderNo).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            orderNoList.forEach(orderNo -> {
                this.orderService.takeDelivery((String)orderNo);
                this.orderDetailService.takeDelivery((String)orderNo);
            });
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            logger.error("\u81ea\u52a8\u6536\u8d27\u64cd\u4f5c\u6570\u636e\u6570\u5931\u8d25\uff1a\u8ba2\u5355\u53f7:{}", (Object)StringUtils.join(orderNoList, (String)","));
            return;
        }
        orderNoList.forEach(orderNo -> this.redisUtil.lPush("alterOrderTakeByUser", orderNo));
    }
}

