<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Observers;

use App\Http\Model\Admin\Admin;
use App\Http\Model\Admin\AdminInfo;
use App\Http\Model\User\User;
use Illuminate\Contracts\Container\BindingResolutionException;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;
use Psr\SimpleCache\InvalidArgumentException;
use Webpatser\Uuid\Uuid;

/**
 * 企业用户观察者.
 */
class AdminObserver
{
    /**
     * Handle the Admin "creating" event.
     * @throws \Exception
     */
    public function creating(Admin $model)
    {
        if (!Admin::exists()) {
            $model->is_admin = 1;
        }
        if (isset($model->birthday)) {
            $model->age = birthday_to_age($model->birthday);
        }
        if (!$model->uniqued) {
            $model->uniqued = str_replace('-', '', (string)Uuid::generate(4));
        }
    }

    /**
     * Handle the Admin "created" event.
     * @throws BindingResolutionException
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     * @throws InvalidArgumentException
     * @throws \ReflectionException
     */
    public function created(Admin $model)
    {
        $user = User::findOrFail($model->uid)?->toArray();
        if ($user) {
            $user['id']        = $model->id;
            $user['entid']     = $model->entid;
            $user['type']      = 1;
            $user['work_time'] = now()->toDateString();
            AdminInfo::updateOrCreate(['id' => $user['id']], $user);
        }
    }

    public function saved(Admin $model)
    {
        $user = User::find($model->uid);
        if ($user) {
            foreach ($model->toArray() as $key => $value) {
                if (in_array($key, ['uid', 'entid'])) {
                    continue;
                }
                if ($key === 'name') $key = 'real_name';
                isset($user->$key) && $user->$key = $value;
            }
            $user->saveQuietly();
        }
    }
}
