<?php

namespace App\Jobs\Attend;

use App\Constants\NoticeEnum;
use App\Http\Service\Attendance\AttendanceRemindService;
use App\Http\Service\Company\CompanyService;
use App\Http\Service\Message\MessageService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

/**
 * 考勤周报
 */
class AttendanceTeamWeeklyJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        $msgService    = app()->get(MessageService::class);
        $remindService = app()->get(AttendanceRemindService::class);
        $tz            = config('app.timezone');
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                $weeklyMessage = $msgService->getMessageContent($entId, NoticeEnum::TEAM_ATTENDANCE_WEEKLY_REMIND);
                if ($weeklyMessage && now()->isMonday() && now()->format('H:i') === $weeklyMessage['remind_time']) {
                    $dateObj = Carbon::now($tz)->subWeek();
                    $date    = $dateObj->startOfWeek()->format('Y/m/d 00:00:00') . '-' . $dateObj->endOfWeek()->format('Y/m/d 23:59:59');
                    $remindService->setEntValue($entId)->sendTeamWeeklyPush($date);
                }
            }
        } catch (\Throwable $e) {
            Log::error('团队周报推送失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }

}
