<?php

namespace App\Jobs\Attend;

use App\Http\Service\Attendance\AttendanceRemindService;
use App\Http\Service\Company\CompanyService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Facades\Log;

class AttendanceShortMessageJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                app()->get(AttendanceRemindService::class)->setEntValue($entId)->sendShortRemindMessage(now());
            }
        } catch (\Throwable $e) {
            Log::error('缺卡提醒推送失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }
}
