<?php

namespace App\Jobs\Attend;

use App\Http\Service\Attendance\AttendanceRemindService;
use App\Http\Service\Company\CompanyService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Facades\Log;

/**
 * 上下班打卡缺卡提醒
 */
class AttendanceRemindJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                app()->get(AttendanceRemindService::class)->setEntValue($entId)->generateShiftRemind(now());
            }
        } catch (\Throwable $e) {
            Log::error('考勤推送数据创建失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }

}
