<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Requests\Common;

use App\Http\Requests\ApiValidate;

/**
 * 企业验证
 * Class AccountLoginRequest.
 */
class CompanyRequest extends ApiValidate
{
    /**
     * 场景.
     * @var \string[][]
     */
    protected $scene = [
        'create' => [
            'enterprise_name', 'uid'
        ],
    ];

    /**
     * 设置规则.
     * @return array|string[]
     */
    public function rules()
    {
        return [
            'name' => 'required|min:5|max:50',
            'uid'  => 'required|min:5|max:200',
        ];
    }

    /**
     * 设置提示语.
     * @return string[]
     */
    public function message()
    {
        return [
            'name.required' => '企业名称必须填写',
            'name.min'      => '企业名称长度不正确',
            'name.max'      => '企业名称长度超出限制',
            'uid.required'  => '用户ID必须填写',
            'uid.min'       => '用户ID不正确!',
            'uid.max'       => '用户ID不正确!'
        ];
    }
}
