<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Model\User;

use App\Http\Model\BaseModel;
use crmeb\traits\model\TimeDataTrait;

/**
 * 用户日程表
 * Class UserSchedule.
 */
class UserScheduleRecord extends BaseModel
{
    use TimeDataTrait;

    /**
     * 表名.
     * @var string
     */
    protected $table = 'user_schedule_record';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * @return mixed
     */
    public function scopeUid($query, $value)
    {
        if ($value !== '') {
            return $query->where('uid', $value);
        }
    }

    /**
     * @return mixed
     */
    public function scopeSchedultid($query, $value)
    {
        if (is_array($value)) {
            $query->whereIn('schedultid', $value);
        } elseif ($value !== '') {
            return $query->where('schedultid', $value);
        }
    }

    public function scopeRemindDay($query, $value)
    {
        if ($value !== '') {
            $query->where('remind_day', $value);
        }
    }
}
