<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Model\User;

use App\Http\Model\BaseModel;
use App\Observers\ResumeObserver;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * 用户简历.
 */
class UserResume extends BaseModel
{
    /**
     * 表名.
     * @var string
     */
    protected $table = 'user_resume';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';
    protected $fillable = ['uid', 'photo', 'name', 'phone', 'position', 'birthday', 'nation', 'politic', 'native', 'address', 'sex', 'age', 'marriage', 'is_part', 'work_years', 'spare_name', 'spare_tel', 'email', 'work_time', 'trial_time', 'formal_time', 'treaty_time', 'social_num', 'fund_num', 'bank_num', 'bank_name', 'graduate_name', 'graduate_date', 'card_id', 'card_front', 'card_both', 'education', 'education_image', 'acad', 'acad_image'
    ];

    public static function boot()
    {
        parent::boot();
        static::observe(ResumeObserver::class);
    }

    /**
     * 工作经历.
     * @return HasMany
     */
    public function works()
    {
        return $this->hasMany(UserWorkHistory::class, 'resume_id', 'id');
    }

    /**
     * 教育经历.
     * @return HasMany
     */
    public function educations()
    {
        return $this->hasMany(UserEducationHistory::class, 'resume_id', 'id');
    }

    /**
     * uid作用域
     * @return mixed
     */
    public function scopeUid($query, $val)
    {
        if ($val !== '') {
            return $query->where('uid', $val);
        }
    }

    /**
     * uid作用域
     * @return mixed
     */
    public function scopeId($query, $val)
    {
        if ($val !== '') {
            return $query->where('id', $val);
        }
    }

    /**
     * NOtId作用域
     * @return mixed
     */
    public function scopeNotId($query, $val)
    {
        if ($val !== '') {
            return $query->where('id', '<>', $val);
        }
    }

    /**
     * id作用域
     * @param mixed $value
     * @return mixed
     */
    public function scopeIds($query, $value)
    {
        if (is_array($value)) {
            return $query->whereIn('id', $value);
        }
        return $query->where('id', $value);
    }

    /**
     * uid作用域
     */
    public function scopeUids($query, $value)
    {
        $query->whereIn('uid', $value);
    }
}
