<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Model\Schedule;

use App\Http\Model\BaseModel;
use crmeb\traits\model\TimeDataTrait;

/**
 * 日程类型表.
 */
class ScheduleType extends BaseModel
{
    use TimeDataTrait;

    /**
     * 表名.
     * @var string
     */
    protected $table = 'schedule_type';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';

    public function scopeUidLike($query, $value)
    {
        if ($value) {
            $query->where(fn ($q) => $q->orWhere('uid', $value)->orWhere('uid', ''));
        }
    }

    public function scopeUseridLike($query, $value)
    {
        if ($value) {
            $query->where(fn ($q) => $q->orWhere('user_id', $value)->orWhere('user_id', 0));
        }
    }

    public function scopeEntLike($query, $value)
    {
        if ($value) {
            $query->where(fn ($q) => $q->orWhere('entid', $value)->orWhere('entid', 0));
        }
    }

    public function scopeTypes($query, $value)
    {
        is_array($value) ? $query->whereIn('types', $value) : $query->where('types', $value);
    }
}
