<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Model\Finance;

use App\Http\Model\BaseModel;
use App\Http\Model\Config\Paytype as SystemPayType;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Query\Builder;

/**
 * 财务支付方式
 * Class Paytype.
 */
class Paytype extends BaseModel
{
    /**
     * 表名.
     * @var string
     */
    protected $table = 'enterprise_paytype';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * @return HasOne
     */
    public function info()
    {
        return $this->hasOne(SystemPayType::class, 'id', 'type_id');
    }

    /**
     * name作用域
     * @param Builder $query
     * @return mixed
     */
    public function scopeTypeId($query, $value)
    {
        if ($value !== '') {
            return $query->where('type_id', $value);
        }
    }

    /**
     * name作用域
     * @param Builder $query
     * @return mixed
     */
    public function scopeTypes($query, $value)
    {
        if (is_array($value)) {
            return $query->whereIn('type_id', $value);
        }
    }

    /**
     * name作用域
     * @param Builder $query
     * @return mixed
     */
    public function scopeName($query, $value)
    {
        if ($value !== '') {
            return $query->where('name', $value);
        }
    }

    /**
     * types作用域
     * @param Builder $query
     * @return mixed
     */
    public function scopeEntid($query, $value)
    {
        if ($value !== '') {
            return $query->where('entid', $value);
        }
    }
}
