<?php

namespace App\Http\Model\Approve;

use App\Http\Model\BaseModel;

class ApproveRole extends BaseModel
{
    protected $table = 'approve_role';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';

    public function setUidsAttribute($value)
    {
        $this->attributes['uids'] = json_encode($value, JSON_UNESCAPED_UNICODE);
    }

    public function getUidsAttribute($value)
    {
        return json_decode($value, true);
    }

    public function scopeId($query, $value)
    {
        return is_array($value) ? $query->whereIn('id', $value) : $query->where('id', $value);
    }
}
