<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Dao\Client;

use App\Http\Dao\BaseDao;
use App\Http\Model\BaseModel;
use App\Http\Model\Client\CustomerLiaison;
use App\Http\Model\Config\FormCate;
use App\Http\Model\Config\FormData;
use crmeb\traits\dao\BatchSearchTrait;
use crmeb\traits\dao\ListSearchTrait;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

/**
 * class CustomerLiaisonDao.
 */
class CustomerLiaisonDao extends BaseDao
{
    use ListSearchTrait;
    use BatchSearchTrait;

    protected function setModel(): string
    {
        return CustomerLiaison::class;
    }

    /**
     * 设置模型.
     * @return BaseModel
     * @throws BindingResolutionException
     */
    public function getModel(bool $need = true)
    {
        $model     = parent::getModel();
        $tableName = 'customer_liaison_' . $this->entId;
        $this->createTableIfNotExists($tableName);
        $model = $model->setTable($tableName);
        if ($need && $this->entId && Schema::hasColumn($tableName, 'entid')) {
            $model = $model->where($tableName . '.entid', $this->entId);
        }
        return $model;
    }

    /**
     * 创建表.
     * @return void
     */
    public function createTableIfNotExists(string $tableName)
    {
        if (!Schema::hasTable($tableName)) {
            Schema::create($tableName, function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->unsignedInteger('entid')->default($this->entId)->index()->comment('企业ID');
                $table->integer('uid')->default(0)->comment('业务员ID');
                $table->integer('eid')->default(0)->comment('客户ID');
                $table->integer('creator_uid')->default(0)->comment('创建人ID');
                $table->string('liaison_name')->default('')->comment('联系人姓名');
                $table->string('liaison_tel')->default('')->comment('联系电话');
                $table->string('liaison_job')->default('公司职员')->comment('联系人职位');
                $table->string('e06d7153')->default('')->comment('性别');
                $table->string('e06d7152')->default('')->comment('联系人邮箱');
                $table->string('e06d7159')->default('')->comment('联系人微信');
                $table->string('l753bf282')->default('')->comment('备注');
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

}
