<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Controller\UniApi\Client;

use App\Http\Controller\UniApi\AuthController;
use App\Http\Service\Client\ClientInvoiceLogService;
use Illuminate\Contracts\Container\BindingResolutionException;
use Spatie\RouteAttributes\Attributes\Get;
use Spatie\RouteAttributes\Attributes\Middleware;
use Spatie\RouteAttributes\Attributes\Prefix;

/**
 * 客户合同发票操作记录
 * Class ClientInvoiceLogController.
 */
#[Prefix('uni/finance/invoice')]
#[Middleware(['auth.admin', 'ent.auth', 'ent.log'])]
class ClientInvoiceLogController extends AuthController
{
    public function __construct(ClientInvoiceLogService $services)
    {
        parent::__construct();
        $this->service = $services;
    }

    /**
     * 展示数据.
     * @param mixed $invoiceId
     * @throws BindingResolutionException
     */
    #[Get('record/{invoiceId}', '获取客户合同发票操作记录列表')]
    public function index($invoiceId): mixed
    {
        $invoiceId = (int) $invoiceId;
        if (! $invoiceId) {
            return $this->fail('common.empty.attrs');
        }
        return $this->success($this->service->getList(['invoice_id' => $invoiceId, 'entid' => $this->entId]));
    }
}
