<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Controller\UniApi\Client;

use App\Http\Controller\UniApi\AuthController;
use App\Http\Requests\enterprise\client\ClientFollowRequest;
use App\Http\Service\Client\ClientFollowService;
use crmeb\interfaces\ResourceControllerInterface;
use crmeb\traits\ResourceControllerTrait;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Validation\ValidationException;
use Spatie\RouteAttributes\Attributes\Middleware;
use Spatie\RouteAttributes\Attributes\Prefix;
use Spatie\RouteAttributes\Attributes\Resource;

/**
 * 客户跟进记录
 * Class ClientFollowController.
 */
#[Prefix('uni/client/follow')]
#[Resource('/', false, except: ['create', 'show', 'edit'], names: [
    'index'   => '获取客户跟进列表',
    'store'   => '保存客户跟进',
    'update'  => '修改客户跟进',
    'destroy' => '删除客户跟进',
], parameters: ['' => 'id'])]
#[Middleware(['auth.admin', 'ent.auth', 'ent.log'])]
class ClientFollowController extends AuthController implements ResourceControllerInterface
{
    use ResourceControllerTrait;

    public function __construct(ClientFollowService $services)
    {
        parent::__construct();
        $this->service = $services;
    }

    /**
     * 展示数据.
     */
    public function index(): mixed
    {
        $where = $this->request->getMore([
            ['eid', ''],
            ['status', 0],
        ]);
        $field = ['id', 'eid', 'user_id', 'content', 'types', 'time', 'uniqued', 'created_at', 'updated_at'];
        return $this->success($this->service->getList($where, $field, 'created_at'));
    }

    /**
     * 添加.
     * @throws BindingResolutionException
     * @throws ValidationException
     */
    public function store(): mixed
    {
        $data        = $this->request->postMore($this->getRequestFields());
        $data['eid'] = $this->request->post('eid', '');
        $this->service->resourceSave($data);
        return $this->success('common.insert.succ');
    }

    protected function getRequestClassName(): string
    {
        return ClientFollowRequest::class;
    }

    protected function getSearchField(): array
    {
        return [
            ['eid', ''],
            ['status', 0],
        ];
    }

    protected function getRequestFields(): array
    {
        return [
            ['content', ''],
            ['attach_ids', []],
            ['types', 0],
            ['time', ''],
        ];
    }
}
