<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Controller\AdminApi;

use App\Http\Model\Attendance\AttendanceShift;
use App\Http\Model\Attendance\AttendanceShiftRule;
use App\Http\Model\Company\Company;
use App\Http\Model\Crud\SystemCrud;
use App\Http\Model\Crud\SystemCrudField;
use App\Http\Model\Open\OpenapiRule;
use App\Http\Service\Attendance\AttendanceClockService;
use App\Http\Service\Attendance\AttendanceWifiService;
use App\Http\Service\Company\CompanyService;
use App\Http\Service\Config\SystemConfigService;
use App\Http\Service\User\UserResumeService;
use App\Task\frame\FrameCensusTask;
use crmeb\traits\service\MenusRouteTrait;
use Hhxsv5\LaravelS\Swoole\Task\Task;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Spatie\RouteAttributes\Attributes\Get;
use Spatie\RouteAttributes\Attributes\Prefix;

#[Prefix('ent')]
class TestController extends AuthController
{
    use MenusRouteTrait;

    #[Get('route/{type}', '接口列表')]
    public function route($api = 'ent')
    {
        echo "<html lang=\"zh-CN\">
<head>
    <title>路由地址列表</title>
</head>
<link rel='stylesheet' type='text/css' href='https://www.layuicdn.com/layui/css/layui.css' />
<body>
<div style='margin: 20px'>
<fieldset class=\"layui-elem-field layui-field-title\" style=\"margin-top: 20px;\">
  <legend>路由地址列表</legend>
</fieldset>
<div class=\"layui-form\">
  <table class=\"layui-table\">
    <thead>
      <tr>
        <th>序号</th>
        <th>请求方式</th>
        <th>接口地址</th>
        <th>接口名称</th>
        <th>接口方法</th>
      </tr>
    </thead>
    <tbody>
  ";
        $routeList = $this->setOption('path', 'api/' . $api)->getRoutes(null);
        $count     = count($routeList);
        $i         = 0;
        echo "<tr>
<td>总条数：共{$count}个接口</td>
</tr>";
        foreach ($routeList as $route) {
            ++$i;
            echo "<tr>
<td>{$i}</td>
<td>{$route['method']}</td>
<td>{$route['uri']}</td>
<td>{$route['name']}</td>
<td>{$route['action']}</td>
</tr>";
        }
        echo '</table></div></div>';
    }

    /**
     * @return mixed
     */
    #[Get('test', name: '测试接口（无需登录）')]
    public function test()
    {
        $entData = app()->get(CompanyService::class)->column([], ['id', 'uid']);
        foreach ($entData as $ent) {
            if ($ent && !AttendanceShift::where('entid', $ent['id'])->where('types', 2)->exists()) {
                $data = AttendanceShift::where('entid', 0)->where('types', 2)->first()?->toArray();
                $rule = AttendanceShiftRule::where('entid', 0)->first()?->toArray();
                if ($data) {
                    DB::transaction(function () use ($data, $ent, $rule) {
                        $data['entid'] = $ent['id'];
                        $data['uid']   = $ent['uid'];
                        unset($data['id']);
                        $newId            = AttendanceShift::create($data);
                        $rule['shift_id'] = $newId->id;
                        $rule['entid']    = $ent['id'];
                        unset($rule['id']);
                        AttendanceShiftRule::create($rule);
                        return true;
                    });
                }
            }
        }
        return $this->success('3333');
    }
}
