<?php

namespace App\Http\Controller\AdminApi\Common;

use App\Http\Controller\AdminApi\AuthController;
use App\Http\Middleware\AuthInternal;
use App\Http\Requests\Common\CompanyRequest;
use App\Http\Service\Common\CommonService;
use crmeb\exceptions\ApiException;
use Spatie\RouteAttributes\Attributes\Middleware;
use Spatie\RouteAttributes\Attributes\Post;
use Spatie\RouteAttributes\Attributes\Prefix;

/**
 * 企业用户.
 */
#[Prefix('ent/internal')]
#[Middleware([AuthInternal::class])]
class InternalController extends AuthController
{
    public function __construct(CommonService $service)
    {
        parent::__construct();
        $this->service = $service;
    }

    /**
     * 创建企业.
     * @param CompanyRequest $request
     * @return mixed
     * @throws \Illuminate\Validation\ValidationException
     */
    #[Post('company/create', '新增企业')]
    public function createCompany(CompanyRequest $request)
    {
        $request->scene('create')->check();
        $data = $request->postMore([
            ['name', '', 'enterprise_name'],
            ['uid', ''],
            ['uniqued', ''],
        ]);
        return $this->success($this->service->createCompany($data));
    }

    /**
     * 创建用户.
     * @return mixed
     * @throws \Throwable
     */
    #[Post('user/create', '新增/修改用户')]
    public function createUser(): mixed
    {
        $data = $this->request->postMore([
            ['name', '', 'real_name'],//姓名
            ['photo', ''],//头像
            ['card_id', ''],//身份证号
            ['education', ''],//学历
            ['nation', ''],//民族
            ['phone', ''],//手机号
            ['sex', 0],//性别
            ['address', ''],//居住地
            ['marriage', 0],//婚姻状况
            ['email', ''],//邮箱
            ['bank_num', '', 'bank_number'],//银行卡号
            ['bank_name', ''],//银行
            ['card_front','']//身份证正面
        ]);
        $uid  = $this->service->saveUser($data, $this->request->input('uid', ''));
        return $this->success('保存成功', compact('uid'));
    }

    /**
     * 用户加入企业
     * @return mixed
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \Psr\Container\NotFoundExceptionInterface
     * @throws \ReflectionException
     */
    #[Post('user/join', '用户加入企业')]
    public function join()
    {
        [$uid, $entId, $uniqued, $frames] = $this->request->postMore([
            ['uid', ''],
            ['ent_id', ''],
            ['uniqued', ''],
            ['frames', []],
        ], true);
        if (!$uid || !$entId) {
            throw new ApiException('参数错误');
        }
        $this->service->userJoinCompany($uid, $entId, $uniqued, $frames);
        return $this->success('已成功加入企业');
    }

    /**
     * 登录.
     * @return mixed
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \Psr\Container\NotFoundExceptionInterface
     */
    #[Post('user/login', '用户登录企业')]
    public function login()
    {
        [$uid, $entId, $cardId] = $this->request->postMore([
            ['uid', ''],
            ['ent_id', ''],
            ['card_id', ''],
        ], true);
        if (!$entId || !$cardId) {
            throw new ApiException('参数错误');
        }
        return $this->success($this->service->userLogin($uid, $entId, $cardId));
    }
}
