<?php

namespace App\Task\system;

use App\Http\Service\Attendance\AttendanceArrangeService;
use Hhxsv5\LaravelS\Swoole\Task\Task;
use Illuminate\Support\Facades\Log;

class AttendanceArrangeTask extends Task
{
    /**
     * @var AttendanceArrangeService|mixed
     */
    private mixed $service;

    /**
     * @param array $where
     * @param $statisticsService
     * @param $groupService
     * @param $shiftService
     * @throws \Psr\Container\ContainerExceptionInterface
     * @throws \Psr\Container\NotFoundExceptionInterface
     */
    public function __construct(protected array $where,protected $statisticsService,protected $groupService,protected $shiftService)
    {
        $this->service = app()->get(AttendanceArrangeService::class);
    }

    public function handle()
    {
        try {
            $this->service->saveRecords($this->where,$this->statisticsService,$this->groupService,$this->shiftService);
        } catch (\Throwable $e) {
            Log::error(__CLASS__ . ':' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine(), 'trace' => $e->getTrace()]);
        }
    }

}
