<?php

namespace App\Jobs\Attend;

use App\Constants\NoticeEnum;
use App\Http\Service\Attendance\AttendanceRemindService;
use App\Http\Service\Company\CompanyService;
use App\Http\Service\Message\MessageService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

/**
 * 考勤月报推送
 */
class AttendanceMonthlyJob extends CronJob
{

    /**
     * 频率：每1m运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        $msgService    = app()->get(MessageService::class);
        $remindService = app()->get(AttendanceRemindService::class);
        $tz            = config('app.timezone');
        try {
            $entIds = app()->get(CompanyService::class)->column(['status' => 1], 'id');
            foreach ($entIds as $entId) {
                $monthlyMessage = $msgService->getMessageContent($entId, NoticeEnum::PERSONAL_MONTHLY_REMIND);
                if ($monthlyMessage && now()->day === 1 && now()->format('H:i') === $monthlyMessage['remind_time']) {
                    $remindService->setEntValue($entId)->sendPersonalPush(Carbon::now($tz)->subMonth()->format('Y-m'), NoticeEnum::PERSONAL_MONTHLY_REMIND, 'month');
                }
            }
        } catch (\Throwable $e) {
            Log::error('个人月报推送失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }

}
