<?php

namespace App\Jobs\Attend;

use App\Http\Service\Attendance\AttendanceStatisticsService;
use Hhxsv5\LaravelS\Swoole\Timer\CronJob;
use Illuminate\Support\Facades\Log;

class AttendanceMemberJob extends CronJob
{
    /**
     * 频率：每1min运行一次
     */
    public function interval(): int
    {
        return 60000;
    }

    public function run(): void
    {
        $date = now()->tz('Asia/Shanghai')->toDateString();
        try {
            app()->get(AttendanceStatisticsService::class)->generateMemberStatistics($date);
        } catch (\Throwable $e) {
            Log::error('考勤数据创建失败：' . $e->getMessage(), ['file' => $e->getFile(), 'line' => $e->getLine()]);
        }
    }
}
