<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Service;

use App\Constants\CacheEnum;
use App\Http\Contract\Common\CommonInterface;
use crmeb\services\SmsService;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Config;
use Mews\Captcha\Captcha;

class CommonService extends BaseService implements CommonInterface
{
    public function captcha(): array
    {
        /** @var Captcha $captcha */
        $captcha = app()->get(Captcha::class);
        return $captcha->create();
    }

    public function smsVerifyKey(): array
    {
        $key = password_hash(uniqid(more_entropy: true), PASSWORD_BCRYPT);
        Cache::tags([CacheEnum::TAG_OTHER])->add('sms.key.' . $key, 0, 300);
        $expire_time = sys_config('verify_expire_time', 1);
        return compact('key', 'expire_time');
    }

    public function smsVerifyCode($phone, $key, $types): bool
    {
        if (!$key) {
            throw $this->exception('请先获取短信发送KEY');
        }
        if (!Cache::tags([CacheEnum::TAG_OTHER])->has('sms.key.' . $key)) {
            throw $this->exception('短信发送KEY已失效请重新获取');
        }
        Cache::tags([CacheEnum::TAG_OTHER])->forget('sms.key.' . $key);
        $letter = app()->get(SmsService::class);
        if ($letter->hasCode($phone)) {
            throw $this->exception('当前手机号验证码已发送,验证码在有效期内可重复使用!');
        }
        $sendNum    = Cache::tags([CacheEnum::TAG_OTHER])->get('sms.send.' . $phone, 0);
        $sendMinNum = Cache::tags([CacheEnum::TAG_OTHER])->get('sms.send.min.' . $phone, 0);
        $config     = Config::get('sms.setting', [
            'maxPhoneCount'  => 20,
            'maxMinuteCount' => 2,
        ]);
        if ($sendNum > $config['maxPhoneCount']) {
            throw $this->exception('当前手机号今日发送验证码已达上限!');
        }
        if ($sendMinNum > $config['maxMinuteCount']) {
            throw $this->exception('当前手机每分钟发送验证码已达上限!');
        }
        $res = $letter->captcha($phone);
        if ($res) {
            if (Cache::tags([CacheEnum::TAG_OTHER])->has('sms.send.' . $phone)) {
                Cache::increment('sms.send.' . $phone);
            } else {
                $ttl = Carbon::today()->endOfDay()->timestamp - Carbon::today()->timestamp;
                Cache::add('sms.send.' . $phone, 1, $ttl);
            }
            if (Cache::tags([CacheEnum::TAG_OTHER])->has('sms.send.min.' . $phone)) {
                Cache::increment('sms.send.min.' . $phone);
            } else {
                Cache::add('sms.send.min.' . $phone, 1, 60);
            }
            return true;
        }
        return false;
    }

    public function createCompany($entId,)
    {

    }
}
