<?php
declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Service;

/**
 * Class BaseEntService
 * @package crmeb\basic
 */
abstract class BaseEntService extends BaseService
{

    /**
     * 条件字段名
     */
    const ENT_FIELD = 'entid';

    public function __get(string $name)
    {
        if (str_contains($name, 'dao')) {
            $this->entId(false) && $this->baseDao->setEntId($this->entId(false));
            return $this->baseDao;
        }
        throw new \Exception('Attribute does not exist' . __CLASS__ . '->' . $name);
    }

    public function __set(string $name, $value): void
    {
        if (str_contains($name, 'dao')) {
            $this->baseDao = $value;
            $this->entId(false) && $this->baseDao->setEntId($this->entId(false));
        }else{
            throw new \Exception('Attribute does not exist' . __CLASS__ . '->' . $name);
        }
    }

    /**
     * 设置默认条件
     * @return array
     */
    protected function getDefaultWhere()
    {
        return [self::ENT_FIELD => $this->entId()];
    }

    /**
     * 初始化
     */
    protected function initialize()
    {
        $this->dao->setDefaultWhere($this->getDefaultWhere());
    }
}
