<?php

namespace App\Http\Service\Approve;

use App\Http\Dao\Approve\ApproveRoleDao;
use App\Http\Service\Admin\AdminService;
use App\Http\Service\BaseEntService;
use crmeb\interfaces\ResourceServicesInterface;
use crmeb\traits\service\ResourceServiceTrait;

class ApproveRoleService extends BaseEntService implements ResourceServicesInterface
{
    use ResourceServiceTrait;

    public function __construct(ApproveRoleDao $dao)
    {
        $this->dao = $dao;
    }

    public function getList(array $where, array $field = ['*'], $sort = null, array $with = []): array
    {
        $list         = $this->dao->select($where, $field, $with)?->toArray();
        $adminService = app()->get(AdminService::class);
        foreach ($list as &$v) {
            $v['users'] = $adminService->select(['id' => $v['uids']], ['id', 'name', 'avatar'])?->toArray();
        }
        $count = $this->dao->count($where);
        return $this->listData($list, $count);
    }

    public function resourceCreate(array $other = []): array
    {
        // TODO: Implement resourceCreate() method.
    }


    public function resourceEdit(int $id, array $other = []): array
    {
        // TODO: Implement resourceEdit() method.
    }

}
