<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Requests\enterprise\file;

use App\Http\Requests\ApiValidate;

/**
 * 文件夹数据验证
 * Class FileFolderRequest.
 */
class FileFolderRequest extends ApiValidate
{
    /**
     * 自动验证
     * @var bool
     */
    public $authValidate = true;

    /**
     * 验证规则.
     * @return array|string[]
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'path' => 'required',
        ];
    }

    /**
     * 错误提示.
     * @return string[]
     */
    public function message()
    {
        return [
            'name.required' => '请填写文件夹名称',
            'path.required' => '请选择上级分类',
        ];
    }
}
