<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Requests\enterprise\client;

use App\Http\Requests\ApiValidate;

class ContractResourceRequest extends ApiValidate
{
    /**
     * 验证场景.
     * @var \string[][]
     */
    protected $scene = [
        'store'  => ['cid', 'content'],
        'update' => ['content'],
    ];

    /**
     * 错误提醒.
     * @return string[]
     */
    public function message()
    {
        return [
            'cid.required'     => '请填写合同ID',
            'cid.numeric'      => '合同ID必须为数字',
            'cid.gt'           => '请填写合同ID',
            'content.required' => '请填写资料描述',
        ];
    }

    /**
     * 规则.
     * @return array|string[]
     */
    protected function rules()
    {
        return [
            'cid'     => 'required|numeric|gt:0',
            'content' => 'required|max:5000',
        ];
    }
}
