<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Model\Config;

use App\Http\Model\BaseModel;

/**
 * 财务支付方式.
 */
class Paytype extends BaseModel
{
    /**
     * 表名.
     * @var string
     */
    protected $table = 'system_paytype';

    /**
     * 主键.
     * @var string
     */
    protected $primaryKey = 'id';

    public function scopeNameLike($query, $value)
    {
        return $value !== '' ? $query->where('name', 'LIKE', "%{$value}%") : null;
    }
}
