<?php

declare(strict_types=1);
/**
 *  +----------------------------------------------------------------------
 *  | 陀螺匠 [ 赋能开发者，助力企业发展 ]
 *  +----------------------------------------------------------------------
 *  | Copyright (c) 2016~2024 https://www.tuoluojiang.com All rights reserved.
 *  +----------------------------------------------------------------------
 *  | Licensed 陀螺匠并不是自由软件，未经许可不能去掉陀螺匠相关版权
 *  +----------------------------------------------------------------------
 *  | Author: 陀螺匠 Team <admin@tuoluojiang.com>
 *  +----------------------------------------------------------------------
 */

namespace App\Http\Middleware;

use crmeb\exceptions\ApiException;
use crmeb\interfaces\ApiMiddlewareInterface;
use crmeb\traits\MiddlewareTrait;
use Illuminate\Http\Request;

/**
 * 检测内部接口权限
 * Class CheckEnterprise.
 */
class AuthInternal implements ApiMiddlewareInterface
{
    use MiddlewareTrait;

    /**
     * 前置事件.
     * @return mixed
     */
    public function before(Request $request)
    {
        if (!$request->hasHeader('Internal-Sign')) {
            throw new ApiException('缺少签名', 40301);
        }
        $sign = $request->header('Internal-Sign', '');
        if (!$sign) {
            throw new ApiException('无效的签名', 40302);
        }
        $path = str_replace('api/ent/internal/', '', $request->path());
        $i    = 0;
        $time = time();
        do {
            if (md5($path . strtoupper($request->method()) . bcsub((string)$time, (string)$i, 0)) === $sign) {
                return true;
            }
            $i++;
        } while ($i < 20);
        throw new ApiException('签名校验失败', 40303);
    }

    /**
     * 后置中间件.
     * @return mixed
     */
    public function after($response)
    {
        // TODO: Implement after() method.
    }
}
