"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Logger = /** @class */ (function () {
    function Logger(id) {
        this.id = id;
        this.start = Date.now();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    Logger.prototype.debug = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        // eslint-disable-next-line no-console
        if (typeof window !== 'undefined' && window.console && typeof console.debug === 'function') {
            // eslint-disable-next-line no-console
            console.debug.apply(console, [this.id, this.getTime() + "ms"].concat(args));
        }
        else {
            this.info.apply(this, args);
        }
    };
    Logger.prototype.getTime = function () {
        return Date.now() - this.start;
    };
    Logger.create = function (id) {
        Logger.instances[id] = new Logger(id);
    };
    Logger.destroy = function (id) {
        delete Logger.instances[id];
    };
    Logger.getInstance = function (id) {
        var instance = Logger.instances[id];
        if (typeof instance === 'undefined') {
            throw new Error("No logger instance found with id " + id);
        }
        return instance;
    };
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    Logger.prototype.info = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        // eslint-disable-next-line no-console
        if (typeof window !== 'undefined' && window.console && typeof console.info === 'function') {
            // eslint-disable-next-line no-console
            console.info.apply(console, [this.id, this.getTime() + "ms"].concat(args));
        }
    };
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    Logger.prototype.error = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        // eslint-disable-next-line no-console
        if (typeof window !== 'undefined' && window.console && typeof console.error === 'function') {
            // eslint-disable-next-line no-console
            console.error.apply(console, [this.id, this.getTime() + "ms"].concat(args));
        }
        else {
            this.info.apply(this, args);
        }
    };
    Logger.instances = {};
    return Logger;
}());
exports.Logger = Logger;
//# sourceMappingURL=logger.js.map