# GWSD WebPTT SDK API

## Author
Jack He

## Version
GWSD_WebPTT_V1.1.4_Alpha

## Date
2024/08/07

## Interface description

### Init
	WebPttInit(
			server,   // server address  for example  ws://192.168.0.1:9000
			{
				pttCb: {
					onLogin:function (status, uid) {
						// login callback
						// status == 0 success
						// status < 0 fail
					},
					onJoinGrp:function (status, gid) {
						// join group callback 
						// status == 0 success
						// status < 0 fail
					},
					onTempGrp:function (status, uid, name) {
						// temp group callback
						// status == 0 call success 
						// status == 1 exit call
						// status == 2 call coming
					},
					onDuplexCall:function (status, uid) {
						// duplex call callback
						// status == 10 && uid == 0 call start 
						// status == 10 && uid > 0 recv call
						// status == 11 call establish
						// status == 15 call end
					},
					onSpeak:function (status, uid) {
						// speak callback
						// status < 0  local speak fail
						// status == 0 uid == 0 other speak end
						// status == 0 uid > 0 other speak start
					},
 					onAddStream:function (dir, stream) {
						// stream add callback
						// dir == 1 speak steam
						// dir == 0 listen steam
					},
					onMessage:function (msg) {
						// receive message
					},
					onLogout:function () {
						// logout callback
					},
					onError:function (code, info) {
						// error callback
					}
				}
			}
		);

### Login
    /*
        account: user account
        password: user password
     */
	PttLogin(account,account,password);

### Join Group
    /*
        account: user account
        gid: join group id
     */
	PttInGroup(account, gid)

### Exit Group
    /*
        account: user account
     */
	PttOutGroup(account)

### Temp Group
    /*
        account: user account
        uid: user id if uid == 0 exit temp group
     */
	PttTempCall(account, uid)

### Message
#### Send message
    /*
        account: user account
        recvtype: msg recv type 0 user message  3 group message
        recvid: msg recv id
        msgtype: message type 1103 text msg 1104 photo msg 1105 video msg 1106 voice msg
        content: message content or url
     */
    PttSendMsg(account,recvtype,recvid,msgtype,content)

### Half Duplex Call
#### Start
    /*
        account: user account
        spkSession: current speak session
     */
    var spkSession = PttStartCall(account)
#### Stop
    /*
        spkSession: current speak session
        stream: speak stream
     */
    PttStopCall(spkSession, stream)

### Full Duplex Call
#### Start
    /*
        account: user account
        uid: remote user id
        spkSession: current speak session
     */
    var spkSession = PttDuplexCall(account,uid)
#### Accept
    /*
        account: user account
        uid: remote user id
        spkSession: current speak session
     */
    var spkSession = PttDuplexAccept(account,uid)
#### Hangup
    /*
        account: user account
        spkSession: current speak session
        uid: remote user id
        stream: speak stream
     */
    PttDuplexHangup(account,spkSession,uid,stream)

### Logout
    /*
        account: user account
        stream: listen stream
     */
    PttLogout(account, stream)



