/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk;

import cn.wildfirechat.pojos.InputChatroomId;
import cn.wildfirechat.pojos.InputChatroomMute;
import cn.wildfirechat.pojos.InputCreateChatroom;
import cn.wildfirechat.pojos.InputDestoryChatroom;
import cn.wildfirechat.pojos.InputGetChatroomInfo;
import cn.wildfirechat.pojos.InputSetChatroomBlacklist;
import cn.wildfirechat.pojos.InputSetChatroomManager;
import cn.wildfirechat.pojos.OutputChatroomBlackInfos;
import cn.wildfirechat.pojos.OutputCreateChatroom;
import cn.wildfirechat.pojos.OutputGetChatroomInfo;
import cn.wildfirechat.pojos.OutputStringList;
import cn.wildfirechat.sdk.model.IMResult;
import cn.wildfirechat.sdk.utilities.AdminHttpUtils;

public class ChatroomAdmin {
    public static IMResult<OutputCreateChatroom> createChatroom(String chatroomId, String title, String desc, String portrait, String extra, Integer state) throws Exception {
        String path = "/admin/chatroom/create";
        InputCreateChatroom input = new InputCreateChatroom();
        input.setChatroomId(chatroomId);
        input.setTitle(title);
        input.setDesc(desc);
        input.setPortrait(portrait);
        input.setExtra(extra);
        input.setState(state);
        return AdminHttpUtils.httpJsonPost(path, input, OutputCreateChatroom.class);
    }

    public static IMResult<Void> destroyChatroom(String chatroomId) throws Exception {
        String path = "/admin/chatroom/del";
        InputDestoryChatroom input = new InputDestoryChatroom();
        input.setChatroomId(chatroomId);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputGetChatroomInfo> getChatroomInfo(String chatroomId) throws Exception {
        String path = "/admin/chatroom/info";
        InputGetChatroomInfo input = new InputGetChatroomInfo(chatroomId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputGetChatroomInfo.class);
    }

    public static IMResult<OutputStringList> getChatroomMembers(String chatroomId) throws Exception {
        String path = "/admin/chatroom/members";
        InputGetChatroomInfo input = new InputGetChatroomInfo(chatroomId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputStringList.class);
    }

    public static IMResult<Void> setChatroomBlacklist(String chatroomId, String userId, int status) throws Exception {
        String path = "/admin/chatroom/set_black_status";
        InputSetChatroomBlacklist input = new InputSetChatroomBlacklist(chatroomId, userId, status, 0L);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputChatroomBlackInfos> getChatroomBlacklist(String chatroomId) throws Exception {
        String path = "/admin/chatroom/get_black_status";
        InputChatroomId input = new InputChatroomId(chatroomId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputChatroomBlackInfos.class);
    }

    public static IMResult<Void> setChatroomManager(String chatroomId, String userId, int status) throws Exception {
        String path = "/admin/chatroom/set_manager";
        InputSetChatroomManager input = new InputSetChatroomManager(chatroomId, userId, status);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }

    public static IMResult<OutputStringList> getChatroomManagerList(String chatroomId) throws Exception {
        String path = "/admin/chatroom/get_manager_list";
        InputChatroomId input = new InputChatroomId(chatroomId);
        return AdminHttpUtils.httpJsonPost(path, input, OutputStringList.class);
    }

    public static IMResult<Void> setChatroomMute(String chatroomId, boolean mute) throws Exception {
        String path = "/admin/chatroom/mute_all";
        InputChatroomMute input = new InputChatroomMute(chatroomId, mute ? 1 : 0);
        return AdminHttpUtils.httpJsonPost(path, input, Void.class);
    }
}

