package com.bcxin.sync.task;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.sync.entity.tenant.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseEntity;
import com.bcxin.sync.service.tenant.TlkAttendanceSiteBaseInfoService;
import com.bcxin.sync.service.tuoluojiang.EbAttendanceGroupService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * description：删除考勤组定时任务
 * author：linchunpeng
 * date：2025/1/10
 */
@Slf4j
@Component
public class DeleteAttendanceGroupTask {

    @Autowired
    private TlkAttendanceSiteBaseInfoService tlkAttendanceSiteBaseInfoService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAttendanceGroupService ebAttendanceGroupService;
    @Autowired
    private RedissonClient redissonClient;

    //每天凌晨0点1分执行
    @Scheduled(cron = "0 1 0 * * ?")
    public void deleteAttendanceGroupTask() {
        log.info("===================================删除考勤组定时任务===================================");
        //分布式锁key
        String lockKey = "REDISSON_LOCK_DELETE_ATTENDANCE_GROUP_TASK";
        //取锁
        log.info("删除考勤组定时任务， lockKey：{}，取锁中.....", lockKey);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            //加锁，并设置过期时间 300s
            if (lock.tryLock(1, 600, TimeUnit.SECONDS)) {
                log.info("取到锁");
                List<EbEnterpriseEntity> enterpriseEntityList = ebEnterpriseService.getAllWithUniquedNotNull();
                if (CollectionUtil.isNotEmpty(enterpriseEntityList)) {
                    log.info("陀螺匠有关联v5的组织，共：{}家", enterpriseEntityList.size());
                    List<String> organizationIdList = enterpriseEntityList.stream().map(EbEnterpriseEntity::getUniqued).collect(Collectors.toList());
                    List<TlkAttendanceSiteBaseInfoEntity> loseEffectivenessList = tlkAttendanceSiteBaseInfoService.getYesterdayLoseEffectivenessByOrganizationIdList(organizationIdList);
                    if (CollectionUtil.isNotEmpty(loseEffectivenessList)) {
                        log.info("这些组织有昨天到期的驻勤点，共：{}个", loseEffectivenessList.size());
                        List<String> attendanceSiteIdList = loseEffectivenessList.stream().map(TlkAttendanceSiteBaseInfoEntity::getId).collect(Collectors.toList());
                        ebAttendanceGroupService.attendanceGroupDelete(attendanceSiteIdList);
                    } else {
                        log.info("这些组织没有昨天到期的驻勤点");
                    }
                } else {
                    log.info("陀螺匠没有关联v5的组织");
                }
            } else {
                log.info("没有取到锁，跳过");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("删除考勤组定时任务异常，{}", e.getMessage(), e);
        } finally {
            if (lock.isLocked() && lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
            log.info("删除考勤组定时任务，lockKey：{}，解锁", lockKey);
        }
        log.info("===================================删除考勤组定时任务结束===================================");
    }

}
