package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbFrameAssistMapper;
import com.bcxin.sync.entity.tuoluojiang.EbFrameAssistEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * description：陀螺匠-部门职员关联服务层
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbFrameAssistService extends ServiceImpl<EbFrameAssistMapper, EbFrameAssistEntity> {

    @Autowired
    private EbFrameService ebFrameService;

    /**
     * description：创建部门人员关联
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void frameAssistCreate(Long entid, String departmentId, Long adminId, Integer isAdmin, Integer isMastart, String departmentEmployeeRelationsId) {
        EbFrameAssistEntity entity;
        LambdaQueryChainWrapper<EbFrameAssistEntity> lqw = this.lambdaQuery();
        lqw.eq(EbFrameAssistEntity::getUniqued, departmentEmployeeRelationsId);
        List<EbFrameAssistEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            //已存在则更新
            entity = list.get(0);
        } else {
            //不存在则新增
            entity = new EbFrameAssistEntity();
            entity.setEntid(entid);
            entity.setUniqued(departmentEmployeeRelationsId);
            entity.setIsMastart(isMastart);
        }

        entity.setFrameId(ebFrameService.getIdByDepartmentId(departmentId));
        entity.setUserId(adminId);
        entity.setIsAdmin(isAdmin);

        this.saveOrUpdate(entity);
    }


    /**
     * description：删除部门人员关联
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void frameAssistDelete(Long entid, Long adminId) {
        LambdaQueryChainWrapper<EbFrameAssistEntity> lqw = this.lambdaQuery();
        lqw.eq(EbFrameAssistEntity::getEntid, entid);
        lqw.eq(EbFrameAssistEntity::getUserId, adminId);
        List<EbFrameAssistEntity> list = lqw.list();
        //删除有关联记录
        if (CollectionUtil.isNotEmpty(list)) {
            this.removeBatchByIds(list.stream().map(EbFrameAssistEntity::getId).collect(Collectors.toList()));
        }
    }

    /**
     * description：删除部门人员关联
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void frameAssistDelete(String departmentEmployeeRelationsId) {
        LambdaQueryChainWrapper<EbFrameAssistEntity> lqw = this.lambdaQuery();
        lqw.eq(EbFrameAssistEntity::getUniqued, departmentEmployeeRelationsId);
        List<EbFrameAssistEntity> list = lqw.list();
        //删除有关联记录
        if (CollectionUtil.isNotEmpty(list)) {
            this.removeById(list.get(0).getId());
        }
    }

}