package com.bcxin.sync.service.tuoluojiang;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.HttpUtil;
import com.bcxin.sync.common.utils.TuoluojiangUtil;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbEnterpriseMapper;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseEntity;
import com.bcxin.sync.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * description：陀螺匠-企业服务层
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbEnterpriseService extends ServiceImpl<EbEnterpriseMapper, EbEnterpriseEntity> {

    @Autowired
    private SyncConfig syncConfig;
    @Value("${spring.profiles.active}")
    private String activeFile;

    @Autowired
    private RedisCache redisCache;

    /**
     * description：创建企业
     * author：linchunpeng
     * date：2024/12/30
     */
    @Transactional
    public String companyCreate(String orgId, String name, String adminId) {
        StringBuffer syncResult = new StringBuffer(64);
        EbEnterpriseEntity entity = this.getEnterpriseByOrgId(orgId);
        if (entity == null) {
            long timeSecond = System.currentTimeMillis()/1000;
            Map<String, String> headerMap = TuoluojiangUtil.getHeaderMap("company/create".concat("POST") + timeSecond);

            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("uniqued", orgId);
            paramMap.put("name", name);
            paramMap.put("uid", adminId);

            HttpUtil.post(syncConfig.getApiHost().getTuoluojiang().concat("/api/ent/internal/company/create"), JSONObject.toJSONString(paramMap), headerMap, "test".equals(activeFile));
            log.info("创建企业成功");
            syncResult.append("\n创建企业成功");
        } else {
            log.info("企业已存在");
            syncResult.append("\n企业已存在");
        }
        return syncResult.toString();
    }

    /**
     * description：通过智能人事组织id获取陀螺匠组织id
     * author：linchunpeng
     * date：2024/12/31
     */
    public Long getIdByOrgId(String orgId) {
        String key = "data-sync:org:entid:" + orgId;
        Object value = redisCache.getCacheObject(key);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        LambdaQueryChainWrapper<EbEnterpriseEntity> lqw = this.lambdaQuery();
        lqw.eq(EbEnterpriseEntity::getUniqued, orgId);
        EbEnterpriseEntity entity = lqw.one();
        if (entity != null) {
            redisCache.setCacheObject(key, entity.getId(), 7, TimeUnit.DAYS);
            return entity.getId();
        }
        return null;
    }

    /**
     * description：通过智能人事组织id列表获取陀螺匠组织
     * author：linchunpeng
     * date：2024/12/31
     */
    public List<EbEnterpriseEntity> getByOrgIds(List<String> orgIds) {
        LambdaQueryChainWrapper<EbEnterpriseEntity> lqw = this.lambdaQuery();
        lqw.in(EbEnterpriseEntity::getUniqued, orgIds);
        return lqw.list();
    }

    /**
     * description：获取陀螺匠所有组织列表（uniqued不为空的）
     * author：linchunpeng
     * date：2024/12/31
     */
    public List<EbEnterpriseEntity> getAllWithUniquedNotNull() {
        LambdaQueryChainWrapper<EbEnterpriseEntity> lqw = this.lambdaQuery();
        lqw.isNotNull(EbEnterpriseEntity::getUniqued);
        return lqw.list();
    }

    /**
     * description：通过智能人事组织id获取陀螺匠组织
     * author：linchunpeng
     * date：2024/12/31
     */
    public EbEnterpriseEntity getEnterpriseByOrgId(String orgId) {
        LambdaQueryChainWrapper<EbEnterpriseEntity> lqw = this.lambdaQuery();
        lqw.eq(EbEnterpriseEntity::getUniqued, orgId);
        return lqw.one();
    }

}
