package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbEnterpriseRoleMapper;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseRoleEntity;
import com.bcxin.sync.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * description：陀螺匠-企业角色表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbEnterpriseRoleService extends ServiceImpl<EbEnterpriseRoleMapper, EbEnterpriseRoleEntity> {

    @Autowired
    private RedisCache redisCache;

    /**
     * description：新增考勤和oa角色
     * author：linchunpeng
     * date：2025/2/18
     */
    @Transactional
    public Long createGetOaAndAttendanceRole(Long entid) {
        String key = "data-sync:ent:oa-attendance-role-id:" + entid.toString();
        Object value = redisCache.getCacheObject(key);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        LambdaQueryChainWrapper<EbEnterpriseRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(EbEnterpriseRoleEntity::getRoleName, "OA与考勤");
        lqw.eq(EbEnterpriseRoleEntity::getEntid, entid);
        List<EbEnterpriseRoleEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            redisCache.setCacheObject(key, list.get(0).getId(), 7, TimeUnit.DAYS);
            return list.get(0).getId();
        }
        EbEnterpriseRoleEntity entity = new EbEnterpriseRoleEntity();
        entity.setEntid(entid);
        entity.setRoleName("OA与考勤");
        entity.setDataLevel(4);
        entity.setDirectly(1);
        entity.setRules("[\"26\",\"14\",\"409\",\"410\",\"585\",\"411\",\"395\",\"586\",\"404\",\"400\",\"405\",\"397\",\"396\",\"179\",\"634\",\"186\"]");
        entity.setRuleUnique("[\"menus649e583268693\",\"menus649e5823d87e1\",\"menus649e72420c1ab\",\"menus649e724b57420\",\"menus64e805f3227ac\",\"menus65c048084eb5f\",\"menus65c0484036e92\",\"menus64e805bb5958a\",\"menus64ec01a28a6c6\",\"menus65c0482ed0f3f\",\"menus64edac6f2298a\",\"menus64edac7e99c0e\",\"menus64edac8d2419d\",\"menus65c048f3990aa\",\"menus65c04820374c3\",\"menus698e727b57420\"]");
        entity.setApis("[\"522\",\"521\",\"520\",\"530\",\"529\",\"528\",\"527\",\"526\",\"525\",\"524\",\"523\",\"507\",\"506\",\"505\",\"510\",\"509\",\"508\",\"426\",\"425\",\"424\",\"427\",\"416\"]");
        entity.setApiUnique("[\"user:examine:add\",\"user:examine:approval:agree\",\"user:examine:approval:refuse\",\"user:examine:approval:details\",\"user:examine:mine:details\",\"business:examine:index:add\",\"business:examine:index:edit\",\"business:examine:index:delete\",\"business:record:index:export\",\"business:record:index:details\",\"business:record:index:delete\",\"hr:attendance:team:add\",\"hr:attendance:team:edit\",\"hr:attendance:team:delete\",\"hr:attendance:shift:add\",\"hr:attendance:shift:check\",\"hr:attendance:shift:edit\",\"hr:attendance:shift:delete\",\"hr:attendance:schedul:add\",\"hr:attendance:schedul:edit\",\"hr:attendance:schedul:copy\",\"hr:attendance:white:save\"]");
        entity.setStatus(1);
        this.save(entity);
        redisCache.setCacheObject(key, entity.getId(), 7, TimeUnit.DAYS);
        return entity.getId();
    }

}