package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAttendanceGroupMemberMapper;
import com.bcxin.sync.entity.tuoluojiang.EbAttendanceGroupMemberEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：陀螺匠-考勤组人员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbAttendanceGroupMemberService extends ServiceImpl<EbAttendanceGroupMemberMapper, EbAttendanceGroupMemberEntity> {

    /**
     * description：根据考勤组id，获取考勤组人员
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<EbAttendanceGroupMemberEntity> getByGroupId(Long groupId) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupMemberEntity::getGroupId, groupId);
        return lqw.list();
    }

    /**
     * description：根据考勤组id，获取考勤组负责人
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<EbAttendanceGroupMemberEntity> getManagerByGroupId(Long groupId) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupMemberEntity::getGroupId, groupId);
        lqw.eq(EbAttendanceGroupMemberEntity::getType, 2);
        return lqw.list();
    }

    /**
     * description：根据考勤组id列表，获取考勤组人员
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<EbAttendanceGroupMemberEntity> getByGroupIdList(List<Long> groupIdList) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.in(EbAttendanceGroupMemberEntity::getGroupId, groupIdList);
        return lqw.list();
    }

    /**
     * description：创建考勤组人员
     * author：linchunpeng
     * date：2025/1/10
     */
    @Transactional
    public EbAttendanceGroupMemberEntity addMember(Long entid, Long groupId, Long adminId, Integer type, boolean isSave) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupMemberEntity::getEntid, entid);
        lqw.eq(EbAttendanceGroupMemberEntity::getGroupId, groupId);
        lqw.eq(EbAttendanceGroupMemberEntity::getMember, adminId);
        lqw.eq(EbAttendanceGroupMemberEntity::getType, type);
        List<EbAttendanceGroupMemberEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            //已存在，判断是否删除，如果是，加回来
            EbAttendanceGroupMemberEntity memberEntity = list.get(0);
            if (memberEntity.getDeletedAt() != null) {
                memberEntity.setDeletedAt(null);
                if (isSave) {
                    this.updateById(memberEntity);
                }
            }
            return memberEntity;
        }
        EbAttendanceGroupMemberEntity memberEntity = new EbAttendanceGroupMemberEntity();
        memberEntity.setEntid(entid);
        memberEntity.setGroupId(groupId);
        memberEntity.setMember(adminId);
        memberEntity.setType(type);
        memberEntity.setCreatedAt(new Date());
        if (isSave) {
            this.save(memberEntity);
        }
        return memberEntity;
    }

    /**
     * description：创建考勤组排除考勤人员
     * author：linchunpeng
     * date：2025/1/10
     */
    @Transactional
    public void addMemberExclude(Long entid, Long groupId, Long adminId) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupMemberEntity::getEntid, entid);
        lqw.ne(EbAttendanceGroupMemberEntity::getGroupId, groupId);//不在当前考勤组
        lqw.eq(EbAttendanceGroupMemberEntity::getMember, adminId);
        lqw.eq(EbAttendanceGroupMemberEntity::getType, 0);//需要考勤
        List<EbAttendanceGroupMemberEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            for (EbAttendanceGroupMemberEntity exist : list) {
                EbAttendanceGroupMemberEntity memberEntity = new EbAttendanceGroupMemberEntity();
                memberEntity.setEntid(entid);
                memberEntity.setGroupId(exist.getGroupId());
                memberEntity.setMember(adminId);
                memberEntity.setType(1);
                memberEntity.setCreatedAt(new Date());
                this.save(memberEntity);
            }
        }
    }

    /**
     * description：删除考勤组人员
     * author：linchunpeng
     * date：2025/1/10
     */
    @Transactional
    public void deleteMember(Long entid, Long groupId, Long adminId, Integer type) {
        LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupMemberEntity::getEntid, entid);
        lqw.eq(EbAttendanceGroupMemberEntity::getGroupId, groupId);
        lqw.eq(EbAttendanceGroupMemberEntity::getMember, adminId);
        lqw.eq(EbAttendanceGroupMemberEntity::getType, type);
        List<EbAttendanceGroupMemberEntity> memberEntityList = lqw.list();
        if (CollectionUtil.isNotEmpty(memberEntityList)) {
            this.removeByIds(memberEntityList.stream().map(EbAttendanceGroupMemberEntity::getId).collect(Collectors.toList()));
            //删除排班记录
            this.baseMapper.deleteEbAttendanceArrangeRecord(groupId, adminId);
            //删除当天的每日统计
            this.baseMapper.deleteEbAttendanceStatistics(groupId, adminId);
        }
    }

    /**
     * description：删除考勤组排除考勤人员
     * author：linchunpeng
     * date：2025/1/10
     */
    @Transactional
    public void deleteMemberExclude(List<Long> adminIdList) {
        if (CollectionUtil.isNotEmpty(adminIdList)) {
            LambdaQueryChainWrapper<EbAttendanceGroupMemberEntity> lqw = this.lambdaQuery();
            lqw.in(EbAttendanceGroupMemberEntity::getMember, adminIdList);
            lqw.eq(EbAttendanceGroupMemberEntity::getType, 1);//排除考勤
            List<EbAttendanceGroupMemberEntity> memberEntityList = lqw.list();
            if (CollectionUtil.isNotEmpty(memberEntityList)) {
                this.removeByIds(memberEntityList.stream().map(EbAttendanceGroupMemberEntity::getId).collect(Collectors.toList()));
            }
        }
    }
}