package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbApproveMapper;
import com.bcxin.sync.dtos.tuoluojiang.ApproveFormContent;
import com.bcxin.sync.entity.tuoluojiang.EbApproveEntity;
import com.bcxin.sync.entity.tuoluojiang.EbApproveFormEntity;
import com.bcxin.sync.entity.tuoluojiang.EbApproveHolidayTypeEntity;
import com.bcxin.sync.entity.tuoluojiang.EbApproveRuleEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * description：陀螺匠-审批表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbApproveService extends ServiceImpl<EbApproveMapper, EbApproveEntity> {

    @Autowired
    private EbApproveHolidayTypeService ebApproveHolidayTypeService;
    @Autowired
    private EbApproveFormService ebApproveFormService;
    @Autowired
    private EbApproveRuleService ebApproveRuleService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Autowired
    private SyncConfig syncConfig;

    /**
     * description：初始审批流程
     * author：linchunpeng
     * date：2025/3/5
     */
    @Transactional
    public void initApprove(String employeeId, Long entid) {
        log.info("初始审批流程，企业id：{}", entid);
        Long adminId = ebAdminService.getIdByEmployeeId(employeeId, entid);
        if (adminId != null) {
            //初始默认组织的所有审批模板
            List<EbApproveEntity> templateList = this.getListByEntid(syncConfig.getOaTemplate().getEntid());
            if (CollectionUtil.isNotEmpty(templateList)) {
                log.info("企业id：{}，存在审批模板，数量：{}，需要初始化", syncConfig.getOaTemplate().getEntid(), templateList.size());
                //假期类型
                List<EbApproveHolidayTypeEntity> holidayTypeEntityList = ebApproveHolidayTypeService.getByEntid(entid);
                List<Long> approveIdList = templateList.stream().map(EbApproveEntity::getId).collect(Collectors.toList());
                //相关的审批表单
                List<EbApproveFormEntity> templateFormEntityList = ebApproveFormService.getListByApproveIdList(approveIdList);
                Map<Long, List<EbApproveFormEntity>> templateFormEntityListMap = templateFormEntityList.stream().collect(Collectors.groupingBy(EbApproveFormEntity::getApproveId));
                //相关的审批规则
                List<EbApproveRuleEntity> templateRuleEntityList = ebApproveRuleService.getListByApproveIdList(approveIdList);
                Map<Long, List<EbApproveRuleEntity>> templateRuleEntityListMap = templateRuleEntityList.stream().collect(Collectors.groupingBy(EbApproveRuleEntity::getApproveId));

                for (EbApproveEntity templateApproveEntity : templateList) {
                    if (this.isExistByEntidAndName(entid, templateApproveEntity.getName())) {
                        log.info("企业id：{}, 存在相同名字【{}】的审批，就不初始化了", entid, templateApproveEntity.getName());
                        continue;
                    }
                    log.info("企业id：{}, 不存在【{}】的审批，需要初始化", entid, templateApproveEntity.getName());
                    EbApproveEntity entity = new EbApproveEntity();
                    BeanUtil.copyProperties(templateApproveEntity, entity, "id");
                    entity.setId(null);
                    entity.setUserId(adminId);
                    entity.setCardId(adminId);
                    entity.setEntid(entid);
                    this.save(entity);
                    Long approveId = entity.getId();
                    log.info("企业id：{}, 初始化【{}】的审批表完成，现在初始化【{}】审批表单", entid, templateApproveEntity.getName(), templateApproveEntity.getName());

                    List<EbApproveFormEntity> formEntityList = new ArrayList<>();
                    List<EbApproveFormEntity> templateFormList = templateFormEntityListMap.get(templateApproveEntity.getId());
                    for (EbApproveFormEntity templateForm : templateFormList) {
                        EbApproveFormEntity formEntity = new EbApproveFormEntity();
                        BeanUtil.copyProperties(templateForm, formEntity, "id");
                        formEntity.setId(null);
                        formEntity.setUserId(adminId);
                        formEntity.setCardId(adminId);
                        formEntity.setEntid(entid);
                        formEntity.setApproveId(approveId);

                        ApproveFormContent templateFormContent = JSONObject.parseObject(templateForm.getContent(), ApproveFormContent.class);
                        templateFormContent.setField(snowflake.snowflakeIdStr());

                        if (CollectionUtil.isNotEmpty(templateFormContent.getChildren())) {
                            for (ApproveFormContent.ApproveFormContentChildren children : templateFormContent.getChildren()) {
                                children.setField(snowflake.snowflakeIdStr());

                                if (CollectionUtil.isNotEmpty(children.getOptions())) {
                                    if ("holidayType".equals(children.getSymbol())) {
                                        //假期类型
                                        List<ApproveFormContent.ApproveFormContentOption> options =new ArrayList<>();
                                        if (CollectionUtil.isNotEmpty(holidayTypeEntityList)) {
                                            for (EbApproveHolidayTypeEntity holidayTypeEntity : holidayTypeEntityList) {
                                                ApproveFormContent.ApproveFormContentOption option = new ApproveFormContent.ApproveFormContentOption();
                                                option.setValue(holidayTypeEntity.getId().toString());
                                                option.setLabel(holidayTypeEntity.getName());
                                                option.setDuration_type(holidayTypeEntity.getDurationType().toString());
                                                options.add(option);
                                            }
                                        }
                                        children.setOptions(options);
                                    }
                                }
                            }
                        }
                        formEntity.setContent(JSONObject.toJSONString(templateFormContent));
                        formEntityList.add(formEntity);
                    }
                    ebApproveFormService.saveBatch(formEntityList);
                    log.info("企业id：{}, 初始化【{}】的审批表单完成，现在初始化【{}】审批规则", entid, templateApproveEntity.getName(), templateApproveEntity.getName());

                    List<EbApproveRuleEntity> ruleEntityList = new ArrayList<>();
                    List<EbApproveRuleEntity> templateRuleList = templateRuleEntityListMap.get(templateApproveEntity.getId());
                    for (EbApproveRuleEntity templateRule : templateRuleList) {
                        EbApproveRuleEntity ruleEntity = new EbApproveRuleEntity();
                        BeanUtil.copyProperties(templateRule, ruleEntity, "id");
                        ruleEntity.setId(null);
                        ruleEntity.setUserId(adminId);
                        ruleEntity.setCardId(adminId);
                        ruleEntity.setEntid(entid);
                        ruleEntity.setApproveId(approveId);
                        ruleEntityList.add(ruleEntity);
                    }
                    ebApproveRuleService.saveBatch(ruleEntityList);
                    log.info("企业id：{}, 初始化【{}】的审批规则完成", entid, templateApproveEntity.getName());
                }
            } else {
                log.info("企业id：{}，不存在审批模板，不需要初始化", syncConfig.getOaTemplate().getEntid());
            }
        }
    }

    /**
     * description：通过企业id、审批类型查询审批
     * author：linchunpeng
     * date：2025/3/5
     */
    private EbApproveEntity getByEntidAndType(Long entid, Integer types) {
        LambdaQueryChainWrapper<EbApproveEntity> lqw = this.lambdaQuery();
        lqw.eq(EbApproveEntity::getEntid, entid);
        lqw.eq(EbApproveEntity::getTypes, types);
        return lqw.one();
    }


    /**
     * description：通过企业id、审批名称判断审批是否存在
     * author：linchunpeng
     * date：2025/3/5
     */
    private boolean isExistByEntidAndName(Long entid, String name) {
        LambdaQueryChainWrapper<EbApproveEntity> lqw = this.lambdaQuery();
        lqw.eq(EbApproveEntity::getEntid, entid);
        lqw.eq(EbApproveEntity::getName, name);
        return lqw.count() > 0;
    }

    /**
     * description：通过企业id查询审批列表
     * author：linchunpeng
     * date：2025/3/5
     */
    private List<EbApproveEntity> getListByEntid(Long entid) {
        LambdaQueryChainWrapper<EbApproveEntity> lqw = this.lambdaQuery();
        lqw.eq(EbApproveEntity::getEntid, entid);
        lqw.eq(EbApproveEntity::getStatus, 1);
        lqw.isNull(EbApproveEntity::getDeletedAt);
        return lqw.list();
    }

}