package com.bcxin.sync.service.tuoluojiang;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbApproveRuleMapper;
import com.bcxin.sync.entity.tuoluojiang.EbApproveRuleEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：陀螺匠-审批规则表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbApproveRuleService extends ServiceImpl<EbApproveRuleMapper, EbApproveRuleEntity> {

    /**
     * description：通过审批id列表，查询审批规则列表
     * author：linchunpeng
     * date：2025/3/5
     */
    public List<EbApproveRuleEntity> getListByApproveIdList(List<Long> approveIdList) {
        LambdaQueryChainWrapper<EbApproveRuleEntity> lqw = this.lambdaQuery();
        lqw.in(EbApproveRuleEntity::getApproveId, approveIdList);
        return lqw.list();
    }


}