package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAdminInfoMapper;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAdminMapper;
import com.bcxin.sync.entity.tuoluojiang.EbAdminEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAdminInfoEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：陀螺匠-职员信息服务层
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbAdminInfoService extends ServiceImpl<EbAdminInfoMapper, EbAdminInfoEntity> {

    public EbAdminInfoEntity getByUserIdAndEntid(String userId, Long entid) {
        LambdaQueryChainWrapper<EbAdminInfoEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAdminInfoEntity::getUid, userId);
        lqw.eq(EbAdminInfoEntity::getEntid, entid);
        List<EbAdminInfoEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public List<EbAdminInfoEntity> getListByUserId(String uid) {
        LambdaQueryChainWrapper<EbAdminInfoEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAdminInfoEntity::getUid, uid);
        return lqw.list();
    }
}