package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.HuaweiIvmUtil;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.tenant.TlkHardwareMapper;
import com.bcxin.sync.dtos.ivm.DeviceDto;
import com.bcxin.sync.entity.tenant.TlkHardwareEntity;
import com.bcxin.sync.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * description：设备表
 * author：linchunpeng
 * date：2025/5/28
 */
@Slf4j
@Service
public class TlkHardwareService extends ServiceImpl<TlkHardwareMapper, TlkHardwareEntity> {

    @Autowired
    private SyncConfig syncConfig;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private IdGeneratorSnowflake snowflake;

    @Value("${spring.profiles.active}")
    private String activeFile;

    /**
     * description：同步所有设置到设备表
     * author：linchunpeng
     * date：2025/5/28
     */
    @Transactional
    public void syncAllHwDevice() {
        log.info("同步所有设置到设备表");
        String accessToken = HuaweiIvmUtil.getAccessToken(syncConfig.getHuaweiIvm().getHost(), syncConfig.getHuaweiIvm().getUserId(), syncConfig.getHuaweiIvm().getAk(), syncConfig.getHuaweiIvm().getSk(), redisCache);
        List<DeviceDto> deviceDtoResultList = HuaweiIvmUtil.getDeviceList(syncConfig.getHuaweiIvm().getHost(), syncConfig.getHuaweiIvm().getUserId(), accessToken);
        List<DeviceDto> deviceDtoList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(deviceDtoResultList)) {
            if ("prod".equals(activeFile)) {
                //生产环境，显示所有的
                deviceDtoList = deviceDtoResultList;
            } else {
                //不是生产环境，就只有一个设备：44000000001320000099
                deviceDtoList = deviceDtoResultList.stream().filter(dto -> dto.getDevice_id().equals("44000000001320000099")).collect(Collectors.toList());
            }
        }
        log.info("拉取到设备列表，数量：{}", deviceDtoList.size());
        //1、先查询数据库中，华为云所有设备编号
        LambdaQueryChainWrapper<TlkHardwareEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkHardwareEntity::getItemDeviceType, "4");
        List<TlkHardwareEntity> existList = lqw.list();
        log.info("数据库中的设备列表，数量：{}", existList.size());
        Set<String> existDeviceNoSet = existList.stream().map(TlkHardwareEntity::getItemDeviceNo).collect(Collectors.toSet());
        Map<String, DeviceDto> deviceDtoMap = deviceDtoList.stream().collect(Collectors.toMap(DeviceDto::getDevice_id, Function.identity()));
        //2、判断哪些是新增的设备
        List<TlkHardwareEntity> insertList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(deviceDtoList)) {
            //拉取下来的设备，不在数据库中，属于新增
            List<DeviceDto> newList = deviceDtoList.stream().filter(dto -> !existDeviceNoSet.contains(dto.getDevice_id())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(newList)) {
                for (DeviceDto deviceDto : newList) {
                    insertList.add(this.createEntity(deviceDto));
                }
            }
        }
        log.info("新增的设备列表，数量：{}", insertList.size());
        //3、哪些是删除的设备
        List<TlkHardwareEntity> removeList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(existList)) {
            //数据库中的设备，不在拉取下来的设备中，属于删除
            removeList = existList.stream().filter(entity -> !deviceDtoMap.containsKey(entity.getItemDeviceNo())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(removeList)) {
                for (TlkHardwareEntity entity : removeList) {
                    entity.setItemStatus("1");
                }
            }
        }
        log.info("删除的设备列表，数量：{}", removeList.size());
        //4、哪些是修改的设备
        List<TlkHardwareEntity> updateList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(existList)) {
            for (TlkHardwareEntity entity : existList) {
                DeviceDto deviceDto = deviceDtoMap.get(entity.getItemDeviceNo());
                if (deviceDto != null) {
                    entity.setItemStatus("0");
                    entity.setItemName(deviceDto.getDevice_name());
                    updateList.add(entity);
                }
            }
        }
        log.info("修改设备列表，数量：{}", updateList.size());
        //5、保存入库
        if (CollectionUtil.isNotEmpty(insertList)) {
            this.saveBatch(insertList);
        }
        if (CollectionUtil.isNotEmpty(removeList)) {
            this.updateBatchById(removeList);
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
    }


    /**
     * description：创建设备
     * author：linchunpeng
     * date：2025/5/28
     */
    private TlkHardwareEntity createEntity(DeviceDto dto) {
        TlkHardwareEntity entity = new TlkHardwareEntity();
        entity.setId(snowflake.snowflakeId() + "--__hw8pZmKQpL6F8rl2lUa");
        entity.setLastmodified(new Date());
        entity.setCreated(new Date());
        entity.setFormid("__hw8pZmKQpL6F8rl2lUa");
        entity.setIstmp(0);
        entity.setVersions(1);
        entity.setApplicationid("__KWBHssgPtqkxvqhTKlW");
        entity.setStateint(0);
        entity.setAuditornames("111");
        entity.setLastmodifier("Lh4euMC9");
        entity.setDomainid("aSuXCEfz");
        entity.setAuditorlist("{}");
        entity.setCoauditorlist("{}");
        entity.setStatelabelinfo("[{\"nodes\":[{\"nodeId\":\"\",\"stateLabel\":\"\",\"state\":\"\",\"auditors\":[],\"coAuditors\":[]}]}]");

        entity.setItemProductPkId(dto.getDevice_id());
        entity.setItemStatus("0");
        entity.setItemDeviceNo(dto.getDevice_id());
        entity.setItemName(dto.getDevice_name());
        entity.setItemDeviceType("4");
        entity.setItemHoldType("0");
        entity.setItemUseType("0");
        entity.setItemDeviceModel(dto.getDevice_type());

        return entity;
    }

}