package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TlkEventTeamMapper;
import com.bcxin.sync.entity.tenant.TlkEventProjectEntity;
import com.bcxin.sync.entity.tenant.TlkEventTeamEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：智能人事-项目表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkEventTeamService extends ServiceImpl<TlkEventTeamMapper, TlkEventTeamEntity> {

    @Autowired
    private TlkEventProjectService tlkEventProjectService;


    /**
     * description：通过团队组织id，获取参与项目的最大结束时间
     * author：linchunpeng
     * date：2025/4/3
     */
    public Date getEndTimeByTeamId(String teamId, Date now) {
        Date endTime = now;
        LambdaQueryChainWrapper<TlkEventTeamEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventTeamEntity::getItemTeamId, teamId);
        lqw.isNotNull(TlkEventTeamEntity::getItemProjectId);
        List<TlkEventTeamEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> projectIdList = list.stream().map(TlkEventTeamEntity::getItemProjectId).collect(Collectors.toList());
            List<TlkEventProjectEntity> projectList = tlkEventProjectService.listByIds(projectIdList);
            for (TlkEventProjectEntity projectEntity : projectList) {
                if (projectEntity.getItemProjectEndTime() != null) {
                    Date itemProjectEndTime = DateUtil.offsetDay(projectEntity.getItemProjectEndTime(), 2);
                    Date itemProjectEndTime_1 = DateUtil.offsetDay(projectEntity.getItemProjectEndTime(), 1);
                    if (itemProjectEndTime.after(endTime) && itemProjectEndTime_1.after(now)) {
                        //实际结束延迟2天，判断时间延迟1天
                        endTime = itemProjectEndTime;
                    }
                }
            }
        }
        return endTime;
    }

    /**
     * description：判断企业是否存在结束时间大于等于昨天的项目
     * author：linchunpeng
     * date：2025/4/3
     */
    public boolean isExistEndDateBeginYesterday(String teamId) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date begin = calendar.getTime();

        LambdaQueryChainWrapper<TlkEventTeamEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventTeamEntity::getItemTeamId, teamId);
        lqw.isNotNull(TlkEventTeamEntity::getItemProjectId);
        List<TlkEventTeamEntity> list = lqw.list();

        if (CollectionUtil.isNotEmpty(list)) {
            List<String> projectIdList = list.stream().map(TlkEventTeamEntity::getItemProjectId).collect(Collectors.toList());
            List<TlkEventProjectEntity> projectList = tlkEventProjectService.listByIds(projectIdList);
            for (TlkEventProjectEntity projectEntity : projectList) {
                if (projectEntity.getItemProjectEndTime() != null && projectEntity.getItemProjectEndTime().after(begin)) {
                   return true;
                }
            }
        }

        return false;
    }


    /**
     * description：通过项目id列表，获取参与项目的团队
     * author：linchunpeng
     * date：2025/4/3
     */
    public List<TlkEventTeamEntity> getTeamByProjectIdList(List<String> projectIdList) {
        LambdaQueryChainWrapper<TlkEventTeamEntity> lqw = this.lambdaQuery();
        lqw.in(TlkEventTeamEntity::getItemProjectId, projectIdList);
        List<TlkEventTeamEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list;
        }
        return null;
    }

}