package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TlkEventProjectMapper;
import com.bcxin.sync.entity.tenant.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.sync.entity.tenant.TlkEventProjectEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * description：智能人事-项目表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkEventProjectService extends ServiceImpl<TlkEventProjectMapper, TlkEventProjectEntity> {


    /**
     * description：通过活动承办方组织id，获取创建项目的最大结束时间
     * author：linchunpeng
     * date：2025/4/3
     */
    public Date getEndTimeByDomainId(String domainId, Date now) {
        Date endTime = now;
        LambdaQueryChainWrapper<TlkEventProjectEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventProjectEntity::getItemDomainId, domainId);
        lqw.isNotNull(TlkEventProjectEntity::getItemProjectEndTime);
        List<TlkEventProjectEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            for (TlkEventProjectEntity projectEntity : list) {
                Date itemProjectEndTime = DateUtil.offsetDay(projectEntity.getItemProjectEndTime(), 2);
                Date itemProjectEndTime_1 = DateUtil.offsetDay(projectEntity.getItemProjectEndTime(), 1);
                if (itemProjectEndTime.after(endTime) && itemProjectEndTime_1.after(now)) {
                    //实际结束延迟2天，判断时间延迟1天
                    endTime = itemProjectEndTime;
                }
            }
        }
        return endTime;
    }


    /**
     * description：查询结束时间在前天的项目
     * author：linchunpeng
     * date：2025/4/3
     */
    public List<TlkEventProjectEntity> getDayBeforeYesterdayEndProject() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - 2);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date begin = calendar.getTime();

        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) + 1);
        Date end = calendar.getTime();

        LambdaQueryChainWrapper<TlkEventProjectEntity> lqw = this.lambdaQuery();
        lqw.ge(TlkEventProjectEntity::getItemProjectEndTime, begin);
        lqw.lt(TlkEventProjectEntity::getItemProjectEndTime, end);

        List<TlkEventProjectEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list;
        }
        return null;
    }


    /**
     * description：判断企业是否存在结束时间大于等于昨天的项目
     * author：linchunpeng
     * date：2025/4/3
     */
    public boolean isExistEndDateBeginYesterday(String domainId) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        Date begin = calendar.getTime();

        LambdaQueryChainWrapper<TlkEventProjectEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventProjectEntity::getItemDomainId, domainId);
        lqw.ge(TlkEventProjectEntity::getItemProjectEndTime, begin);

        return lqw.exists();
    }

}