package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TlkAttendanceSitePersonInfoMapper;
import com.bcxin.sync.entity.tenant.TlkAttendanceSitePersonInfoEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：智能人事-驻勤点人员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkAttendanceSitePersonInfoService extends ServiceImpl<TlkAttendanceSitePersonInfoMapper, TlkAttendanceSitePersonInfoEntity> {

    /**
     * description：根据驻勤点id列表，获取驻勤点人员
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<TlkAttendanceSitePersonInfoEntity> getByAttendanceSiteIdList(List<String> itemAttendanceSiteIdList) {
        LambdaQueryChainWrapper<TlkAttendanceSitePersonInfoEntity> lqw = this.lambdaQuery();
        lqw.in(TlkAttendanceSitePersonInfoEntity::getItemAttendanceSiteId, itemAttendanceSiteIdList);
        lqw.isNotNull(TlkAttendanceSitePersonInfoEntity::getItemSecurityId);
        return lqw.list();
    }

}