package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TenantDepartmentEmployeeRelationsMapper;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * description：智能人事-部门职员关联表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantDepartmentEmployeeRelationsService extends ServiceImpl<TenantDepartmentEmployeeRelationsMapper, TenantDepartmentEmployeeRelationsEntity> {

    /**
     * description：通过部门id列表，查询部门与员工关联表
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<TenantDepartmentEmployeeRelationsEntity> getListByDepartmentIdList(Set<String> departmentIdList) {
        LambdaQueryChainWrapper<TenantDepartmentEmployeeRelationsEntity> lqw = this.lambdaQuery();
        lqw.in(TenantDepartmentEmployeeRelationsEntity::getDepartmentId, departmentIdList);
        return lqw.list();
    }

    /**
     * description：通过员工id列表，查询部门与员工关联表
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<TenantDepartmentEmployeeRelationsEntity> getListByEmployeeIdList(List<String> employeeIdList) {
        LambdaQueryChainWrapper<TenantDepartmentEmployeeRelationsEntity> lqw = this.lambdaQuery();
        lqw.in(TenantDepartmentEmployeeRelationsEntity::getEmployeeId, employeeIdList);
        return lqw.list();
    }

}