package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.SuperviseDepartmentMapper;
import com.bcxin.sync.entity.datasync.ThirdPageSettingEntity;
import com.bcxin.sync.entity.tenant.SuperviseDepartmentEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * description：智能人事-监管机构表
 * author：linchunpeng
 * date：2025/4/9
 */
@Slf4j
@Service
public class SuperviseDepartmentService extends ServiceImpl<SuperviseDepartmentMapper, SuperviseDepartmentEntity> {

    /**
     * description：根据id获取层级树
     * author：linchunpeng
     * date：2025/4/9
     */
    public String getIndexCodeById(String id) {
        LambdaQueryChainWrapper<SuperviseDepartmentEntity> lqw = this.lambdaQuery();
        lqw.eq(SuperviseDepartmentEntity::getId, id);
        return lqw.one().getIndexCode();
    }

}